import React, {useState, useEffect} from 'react';
import ChangeSmartOTPView from './ChangeSmartOTPView';
import {
  getOTPApiSmartOTP,
  verifyOTPApiSmart,
} from '../../../apis/Functions/users';
import {showAlert, TYPE} from '../../../components/DropdownAlert';
import {connect} from 'react-redux';
import {hideLoading, showLoading} from '../../../actions/loadingAction';

import {useNavigation} from '@react-navigation/native';
import {CONFIRMCHANGESMARTOTP} from '../../../routers/ScreenNames';

const EnterPasswordSmartOTP = (props) => {
  const navigation = useNavigation();
  const [firstNumber, setFirstNumber] = useState(null);
  const [secondsNumber, setSecondsNumber] = useState(null);
  const [thirdNumber, setThirdNumber] = useState(null);
  const [fourNumber, setFourNumber] = useState(null);
  useEffect(() => {
    if (fourNumber) {
      onCheckPINSmartOTPPin();
    }
  }, [fourNumber]);
  const onNumberPress = (number) => {
    if (!firstNumber) {
      setFirstNumber(number.toString());
    } else if (!secondsNumber) {
      setSecondsNumber(number.toString());
    } else if (!thirdNumber) {
      setThirdNumber(number.toString());
    } else if (!fourNumber) {
      setFourNumber(number.toString());
    }
  };
  console.log('Pros pass', props.route.params);
  const onCheckPINSmartOTPPin = async () => {
    let pinCode = `${firstNumber}${secondsNumber}${thirdNumber}${fourNumber}`;
    setFirstNumber(null);
    setSecondsNumber(null);
    setThirdNumber(null);
    setFourNumber(null);

    if (props.route.params.isFromTransaction) {
      navigation.navigate(CONFIRMCHANGESMARTOTP, {
        pre_otp: pinCode,
        old_password: props.route.params.old_password,
        isFromTransaction: props.route.params.isFromTransaction,
        TYPE: props.route.params.TYPE,
        setupSmartOTPSuccess: props.route.params.setupSmartOTPSuccess,
      });
    } else {
      navigation.navigate(CONFIRMCHANGESMARTOTP, {
        pre_otp: pinCode,
        old_password: props.route.params.old_password,
        TYPE: props.route.params.TYPE,
      });
    }
  };
  const onDeletePress = () => {
    if (fourNumber) {
      setFourNumber(null);
    } else if (thirdNumber) {
      setThirdNumber(null);
    } else if (secondsNumber) {
      setSecondsNumber(null);
    } else if (firstNumber) {
      setFirstNumber(null);
    }
  };

  return (
    <ChangeSmartOTPView
      firstNumber={firstNumber}
      secondsNumber={secondsNumber}
      thirdNumber={thirdNumber}
      fourNumber={fourNumber}
      onNumberPress={onNumberPress}
      onDeletePress={onDeletePress}
    />
  );
};
const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};

export default connect(mapStateToProps, {showLoading, hideLoading})(
  EnterPasswordSmartOTP,
);
