import React from 'react';
import {Alert} from 'react-native';

import SettingView from './SettingView';
import {updateLangugeApi} from '../../apis/Functions/users';
import I18n from '../../helper/i18/i18n';
import {connect} from 'react-redux';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import {showAlert, TYPE} from '../../components/DropdownAlert';

const Setting = (props) => {
  const convertKeyLanguage = (key) => {
    if (key == 'en') return 'ENGLISH';
    return 'VIETNAMESE';
  };

  const updateLangue = async (key) => {
    props.showLoading();
    const res = await updateLangugeApi({
      platform: Platform.OS,
      language: convertKeyLanguage(key),
    });
    props.hideLoading();
    if (res.data.code == 200) {
      showAlert(TYPE.SUCCESS, I18n.t('Notification'), res.data.message);
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
    }
  };

  return <SettingView updateLangue={updateLangue} />;
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {
  showLoading,
  hideLoading,
})(Setting);
