import React, {useState, useEffect, useRef} from 'react';
import {Modal, View, TouchableWithoutFeedback, TouchableOpacity, StyleSheet, Text, TextInput} from 'react-native';
import IconClose from 'react-native-vector-icons/AntDesign';
import R from '../../assets/R';
import {WIDTHXD, getWidth, HEIGHTXD, getFontXD, getHeight} from '../../Config/Functions';
import {showAlert, TYPE} from '../../components/DropdownAlert';
import I18n from '../../helper/i18/i18n';
import DropdownAlert from 'react-native-dropdownalert';

const EnterPasswordModal = (props) => {
  const [visible, setVisible] = useState(true);
  const [pass, setPass] = useState('');
  const dropDownAlertRef = useRef(null);
  const onChangeText = (text) => {
    setPass(text);
  };
  useEffect(() => {
    setVisible(props.visible);
  }, [props.visible]);

  return <Modal
    animationType='slide'
    transparent={true}
    visible={visible}
    onRequestClose={() => {
      props.setVisible(false);
      setPass('');
    }}
  >
    <TouchableOpacity
      style={styles.opacity}
      activeOpacity={1}
      onPressOut={() => {
        setPass('');
        props.setVisible(false);
      }}
    >
      <TouchableWithoutFeedback>
        <View style={styles.modal}>
          <View style={styles.viewTitle}>
            <View style={styles.viewEmpty}></View>
            <Text style={styles.titlePopup}>{I18n.t('EnterPasswordTitle')}</Text>
            <TouchableOpacity onPress={() => {
              setPass('');
              props.setVisible(false);
            }} style={styles.btClose}>
              <IconClose name='close' size={WIDTHXD(48)} color={R.colors.black}/>
            </TouchableOpacity>
          </View>
          <TextInput
            autoCapitalize="none"
            onChangeText={(val) => onChangeText(val)}
            style={styles.txtInput}
            placeholderTextColor={R.colors.placeHolder}
            secureTextEntry={true}
            autoFocus={true}
            value={pass}
          />
          <TouchableOpacity onPress={() => {
            if (pass == '') {
              dropDownAlertRef.current.alertWithType(TYPE.WARN, I18n.t('Notification'), `${I18n.t('Please_fill_in')}${I18n.t('Password')}`);
            } else {
              props.accept(pass);
              setPass('');
            }

          }}>
            <Text style={styles.txtAccept}>{I18n.t('Ok')}</Text>
          </TouchableOpacity>
        </View>
      </TouchableWithoutFeedback>
      <DropdownAlert
        inactiveStatusBarBackgroundColor={R.colors.main}
        activeStatusBarBackgroundColor={R.colors.main}
        warnImageSrc={R.images.iconWarn}
        successImageSrc={R.images.iconSuccess}
        errorImageSrc={R.images.iconError}
        titleStyle={{color: '#fff'}}
        messageStyle={{color: '#fff'}}
        updateStatusBar={false}
        closeInterval={1000}
        ref={dropDownAlertRef}
        warnColor={R.colors.orange400}
        defaultContainer={{
          borderBottomRightRadius: WIDTHXD(30),
          borderBottomLeftRadius: WIDTHXD(30),
          paddingTop: HEIGHTXD(30),
          paddingVertical: HEIGHTXD(30),
          paddingHorizontal: WIDTHXD(20),
        }}
      />
    </TouchableOpacity>

  </Modal>;
};
const styles = StyleSheet.create({
  opacity: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#rgba(0,0,0,0.7)',
  },
  titlePopup: {
    fontSize: getFontXD(48),
    color: R.colors.black,
    textAlign: 'center',
    flex: 10,
  },
  viewEmpty: {
    flex: 1,
  },
  viewTitle: {
    flexDirection: 'row',
    width: WIDTHXD(960),
    borderBottomWidth: 0.3,
    paddingBottom: HEIGHTXD(50),
    borderBottomColor: R.colors.iconGray,
    borderColor: R.colors.iconGray,
  },
  txtAccept: {
    fontSize: getFontXD(48),
    color: R.colors.main,
    textAlign: 'center',
    marginTop: HEIGHTXD(50),
  },
  btClose: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'flex-start',
  },
  modal: {
    backgroundColor: R.colors.white,
    width: WIDTHXD(960),
    justifyContent: 'center',
    // maxHeight: HEIGHTXD(1300),
    borderRadius: WIDTHXD(20),
    paddingBottom: WIDTHXD(40),
    // minHeight: HEIGHTXD(369),
    paddingVertical: HEIGHTXD(59),
    paddingTop: HEIGHTXD(61),
    paddingHorizontal: WIDTHXD(60),
    alignItems: 'center',
  },
  txtInput: {
    width: WIDTHXD(880),
    height: HEIGHTXD(109),
    marginTop: HEIGHTXD(50),
    color: 'black',
    borderRadius: 7,
    borderWidth: 0.7,
    borderColor: '#DBDBDB',
    fontSize: getFontXD(42),
    paddingVertical: 5,
    paddingHorizontal: 10,
    backgroundColor: 'white',
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,

  },
});

export default EnterPasswordModal;
