import React from 'react';
import {
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  Image,
  Alert,
} from 'react-native';
import {getFontXD, HEIGHTXD, WIDTHXD, toPriceVnd} from '../../Config/Functions';
import R from '../../assets/R';
import Block from '../../components/Block';

const Item = (props) => {
  const {item} = props;
  return (
    <View style={styles.container}>
      <Block flex={1} row>
        <View style={styles.wrapDate}>
          <Image source={{uri: item.icon}} style={styles.imgIcon} />
        </View>
        <Block padding={[5, 10]} space={'between'} flex={1}>
          <Text numberOfLines={2} style={styles.txtBlack}>
            {item.body}
          </Text>
          <Text style={styles.txt}>{item.pushed_at}</Text>
        </Block>
      </Block>
    </View>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    marginTop: 8,
    paddingVertical: 10,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    marginHorizontal: 10,
    backgroundColor: R.colors.white,
    marginBottom: 2,
    borderRadius: HEIGHTXD(30),
  },

  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  wrapDate: {
    justifyContent: 'center',
    paddingLeft: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    fontWeight: 'bold',
  },
  txt: {
    fontSize: getFontXD(39),
    color: '#929292',
    fontStyle: 'italic',
  },
  rowBet: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  txtBlack: {
    fontSize: getFontXD(36),
    color: 'black',
  },
  imgIcon: {
    width: WIDTHXD(178),
    height: HEIGHTXD(178),
    resizeMode: 'contain',
  },
});
