import React, {Component} from 'react';
import {
  View,
  Text,
  StyleSheet,
  ImageBackground,
  TouchableOpacity,
  FlatList,
  ScrollView,
} from 'react-native';
import R from '../../../assets/R';
import LinearGradient from 'react-native-linear-gradient';
import {getFontXD} from '../../../Config/Functions';
import Block from '../../../components/Block';
import Icon from 'react-native-vector-icons/AntDesign';
import TopMedia from './TopMedia';
import Item from './Item';

const MediaView = (props) => {
  const {data, mediaHot} = props;

  return (
    <ScrollView showsVerticalScrollIndicator={false} style={{flex: 1}}>
      <TopMedia mediaHot={mediaHot} />
      <View style={{paddingHorizontal: 10, flex: 1, marginTop: 10}}>
        {data.map((item, index) => (
          <View key={index + 'g'} style={styles.containerItem}>
            <Text style={styles.txtTitle}>{item.name}</Text>
            <FlatList
              horizontal={true}
              showsHorizontalScrollIndicator={false}
              keyExtractor={(itemChil) => itemChil.id}
              data={item.data}
              renderItem={({item}) => <Item item={item} />}
            />
          </View>
        ))}
      </View>
      <View style={{height: 50}} />
    </ScrollView>
  );
};

const styles = StyleSheet.create({
  containerTop: {
    height: 350,
    width: '100%',
  },
  containerItem: {
    padding: 10,
    borderBottomWidth: 0.6,
    borderBottomColor: R.colors.borderGray,
  },
  txtTitle: {
    fontSize: getFontXD(52),
    color: R.colors.black,
    fontWeight: 'bold',
    textTransform: 'uppercase',
  },
});

export default MediaView;
