import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity, Image} from 'react-native';
import {getFontXD, HEIGHTXD, WIDTHXD, toPriceVnd} from '../../Config/Functions';
import R from '../../assets/R';
import Block from '../../components/Block';
import Icon from 'react-native-vector-icons/MaterialCommunityIcons';
import {useNavigation} from '@react-navigation/native';
import {METHODPAYDETAIL} from '../../routers/ScreenNames';
import AppText from '../../components/AppText';
const Item = (props) => {
  const navigate = useNavigation();

  const {item} = props;
  return (
    <TouchableOpacity onPress={() => navigate.navigate(METHODPAYDETAIL, item)}>
      <View style={styles.container}>
        <Block flex={1} row center padding={[10, 10]}>
          <Image source={{uri: item.bank.logo}} style={styles.imgIcon} />
          <Block padding={[0, 10]}>
            <Text style={styles.txtBig}>{item.title}</Text>

            <Block space={'between'} flex={1}>
              <View
                style={{flex: 1, flexDirection: 'row', alignItems: 'center'}}>
                <View style={{width: 80}}>
                  <AppText style={styles.txtLeft} i18nKey={'OwnerAccount'} />
                </View>
                <View style={{flex: 1}}>
                  <Text style={styles.txtRight}>{item.account_name}</Text>
                </View>
              </View>

              <View
                style={{flex: 1, flexDirection: 'row', alignItems: 'center'}}>
                <View style={{width: 80}}>
                  <Text style={styles.txtLeft}>STK</Text>
                </View>
                <View style={{flex: 1}}>
                  <Text style={styles.txtRight}>{item.account_no}</Text>
                </View>
              </View>
              <View
                style={{flex: 1, flexDirection: 'row', alignItems: 'center'}}>
                <View style={{width: 80}}>
                  <AppText style={styles.txtLeft} i18nKey={'Branch'} />
                </View>
                <View style={{flex: 1}}>
                  <Text style={styles.txtRight}>{item.branch_name}</Text>
                </View>
              </View>
            </Block>
          </Block>
        </Block>
      </View>
    </TouchableOpacity>
  );
};

export default React.memo(Item);

const styles = StyleSheet.create({
  container: {
    marginTop: 10,
    paddingVertical: 5,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    marginHorizontal: 10,
    backgroundColor: R.colors.white,
    marginBottom: 10,
    borderRadius: HEIGHTXD(30),
  },

  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  wrapDate: {
    justifyContent: 'center',
    paddingLeft: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    fontWeight: 'bold',
  },
  txt: {
    fontSize: getFontXD(39),
    color: '#929292',
    fontStyle: 'italic',
  },
  rowBet: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  txtBlack: {
    fontSize: getFontXD(42),
    color: 'black',
  },
  imgIcon: {
    width: 90,
    height: 90,
    resizeMode: 'contain',
  },
  txtLeft: {
    fontSize: getFontXD(36),
    color: '#929292',
    marginBottom: 5,
  },
  txtBig: {
    fontSize: getFontXD(42),
    color: '#00359C',
  },
  txtRight: {
    fontSize: getFontXD(36),
    marginBottom: 5,
  },
});
