import React, {useState} from 'react';
import {
  View,
  Text,
  TouchableOpacity,
  StyleSheet,
  Alert,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
  TouchableWithoutFeedback,
  Keyboard,
} from 'react-native';
import R from '../../../../assets/R';
import PickerDate from '../../../../components/Picker/PickerDate';
import TextMulti from '../../../../components/Input/TextMulti';
import {connect} from 'react-redux';
import {showLoading, hideLoading} from '../../../../actions/loadingAction';
import {saveUserToRedux} from '../../../../actions/users';
import AppText from '../../../../components/AppText';
import I18n from '../../../../helper/i18/i18n';
import TextField from '../../../../components/Input/TextField';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  renderStatus,
  checkFormatArray,
} from '../../../../Config/Functions';
import {updateInforUser} from '../../../../apis/Functions/users';
import {showAlert, TYPE} from '../../../../components/DropdownAlert';

const GeneralInfor = (props) => {
  const [phone, setPhone] = useState(props.user.phone);
  const [address, setAddress] = useState(props.user.address);

  const onClick = async () => {
    const titles = [
      I18n.t('Phone').toLowerCase(),
      I18n.t('Address').toLowerCase(),
    ];
    const index = checkFormatArray([phone, address]);
    if (index === true) {
      props.showLoading();
      const res = await updateInforUser({
        uid: props.user.uid,
        platform: Platform.OS,
        phone,
        address,
      });
      props.hideLoading();
      if (res.data.code == 200) {
        props.saveUserToRedux(res.data.data);
        showAlert(TYPE.SUCCESS, I18n.t('Notification'), res.data.message);
        props.navigation.popToTop();
      } else {
        showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
      }
    } else {
      showAlert(
        TYPE.ERROR,
        I18n.t('Notification'),
        I18n.t('Please_fill_in') + titles[index],
      );
    }
  };

  const renderMale = () => {
    if (props.user.gender == 1) return I18n.t('Female');
    return I18n.t('Male2');
  };

  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-500}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <ScrollView style={{flex: 1}} showsVerticalScrollIndicator={false}>
          <View style={styles.container}>
            <View style={styles.wrapItem}>
              <View style={styles.wrapLeft}>
                <AppText i18nKey={'Fullname'} style={styles.txtTitle}></AppText>
              </View>
              <View style={styles.wrapRight}>
                <Text style={styles.txtRight}>{props.user.fullname}</Text>
              </View>
            </View>
            <View style={styles.wrapItem}>
              <View style={styles.wrapLeft}>
                <Text style={styles.txtTitle}>Email</Text>
              </View>
              <View style={styles.wrapRight}>
                <Text style={styles.txtRight}>{props.user.email}</Text>
              </View>
            </View>
            <View style={styles.wrapItem}>
              <View style={styles.wrapLeft}>
                <AppText i18nKey={'Birth'} style={styles.txtTitle}></AppText>
              </View>
              <View style={styles.wrapRight}>
                <Text style={styles.txtRight}>{props.user.birthday}</Text>
              </View>
            </View>
            <View style={styles.wrapItem}>
              <View style={styles.wrapLeft}>
                <AppText i18nKey={'Male'} style={styles.txtTitle}></AppText>
              </View>
              <View style={styles.wrapRight}>
                <Text style={styles.txtRight}>{renderMale()}</Text>
              </View>
            </View>
            <View style={styles.wrapItem}>
              <View style={styles.wrapLeft}>
                <AppText i18nKey={'Status'} style={styles.txtTitle}></AppText>
              </View>
              <View style={styles.wrapRight}>
                <Text style={styles.txtRight}>{props.user.status_name}</Text>
              </View>
            </View>

            <TextField
              title={I18n.t('Phone')}
              value={phone}
              onChangeText={(val) => setPhone(val)}
            />

            <TextMulti
              onChangeText={(val) => setAddress(val)}
              value={address}
              title={I18n.t('Address')}
            />

            <View style={{height: 40}} />
            <View style={{justifyContent: 'center', alignItems: 'center'}}>
              <TouchableOpacity onPress={onClick} style={styles.btn}>
                <AppText i18nKey={'Update'} style={styles.txtBtn}></AppText>
              </TouchableOpacity>
            </View>
          </View>
        </ScrollView>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    paddingHorizontal: 10,
    paddingVertical: 10,
  },
  wrapItem: {
    flexDirection: 'row',
    marginVertical: 5,
  },
  customTxt: {
    height: HEIGHTXD(110),
    color: 'black',
    borderRadius: 7,
    borderWidth: 0.7,
    borderColor: '#DBDBDB',
    fontSize: getFontXD(42),
    paddingVertical: 5,
    paddingHorizontal: 10,
    backgroundColor: 'white',
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
    marginTop: 50,
    marginBottom: 20,
  },
  wrapLeft: {
    flex: 1,
  },
  wrapRight: {
    flex: 2,
  },
  status: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginVertical: 10,
    alignItems: 'center',
  },
  footer: {
    justifyContent: 'center',
    alignItems: 'center',
    marginBottom: 30,
  },
  btn: {
    width: WIDTHXD(400),
    height: HEIGHTXD(100),
    borderRadius: 10,
    backgroundColor: '#1C6AF6',
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtBtn: {
    color: R.colors.white,
    fontSize: getFontXD(52),
    textTransform: 'uppercase',
  },
  customAdd: {
    borderWidth: 1,
    borderColor: '#929292',
    paddingHorizontal: 5,
    borderRadius: 5,
    marginRight: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,

    paddingTop: 5,
  },
  txtRight: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    marginBottom: 5,

    paddingTop: 5,
  },
  row: {
    height: HEIGHTXD(109),
    width: '100%',
    justifyContent: 'space-between',
    marginVertical: 5,
    width: 250,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {
  showLoading,
  saveUserToRedux,
  hideLoading,
})(GeneralInfor);
