import React from 'react';
import {View, Text, TouchableOpacity, Image, StyleSheet} from 'react-native';
import R from '../../../../assets/R';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  logout,
} from '../../../../Config/Functions';
import {connect} from 'react-redux';
import AppText from '../../../../components/AppText';
import I18n from '../../../../helper/i18/i18n';
import {useNavigation} from '@react-navigation/native';
import {PACKETCQG} from '../../../../routers/ScreenNames';
import {closeCQG} from '../../../../apis/Functions/packetCQG';
import {showLoading, hideLoading} from '../../../../actions/loadingAction';
import {showAlert, TYPE} from '../../../../components/DropdownAlert';

const Profile = (props) => {
  const navigation = useNavigation();

  const onClickCLose = async () => {
    props.showLoading();
    const res = await closeCQG();
    props.hideLoading();
    if (res.data.code == 200) {
      showAlert(TYPE.SUCCESS, I18n.t('Notification'), res.data.message);
    } else if (res.data.code == 401) {
      logout(navigation);
      showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
    }
  };

  return (
    <View style={styles.container}>
      {props.user.status == 6 ||
      props.user.status == 7 ||
      props.user.status == 8 ? (
        <View>
          <View style={styles.item}>
            <AppText i18nKey={'ContactCode'} style={styles.txtTitle}></AppText>
            <Text style={styles.txtBig}>{props.user.contract_code}</Text>
          </View>
          <View style={styles.item}>
            <AppText
              i18nKey={'TraddingAccountName'}
              style={styles.txtTitle}></AppText>
            <Text style={styles.txtBig}>{props.user.cqg_name}</Text>
          </View>
          <View style={styles.item}>
            <AppText
              i18nKey={'TraddingAccountNumber'}
              style={styles.txtTitle}></AppText>
            <Text style={styles.txtBig}>{props.user.cqg_account}</Text>
          </View>
          {props.user.status == 6 ? (
            <View
              style={{
                flexDirection: 'row',
                alignItems: 'center',
                justifyContent: 'space-between',
                marginTop: 50,
              }}>
              <TouchableOpacity
                onPress={() => navigation.navigate(PACKETCQG)}
                style={styles.btnLeft}>
                <AppText
                  i18nKey={'UpdatePacket'}
                  style={styles.txtBtn}></AppText>
              </TouchableOpacity>
              <TouchableOpacity onPress={onClickCLose} style={styles.btnRight}>
                <AppText
                  i18nKey={'CloseAccount'}
                  style={styles.txtBtn}></AppText>
              </TouchableOpacity>
            </View>
          ) : null}
        </View>
      ) : (
        <View style={{justifyContent: 'center', alignItems: 'center', flex: 1}}>
          {props.user.status == 5 ? (
            <AppText
              i18nKey={'WaitVerification'}
              style={styles.txtNoti1}></AppText>
          ) : (
            <View style={{justifyContent: 'center', alignItems: 'center'}}>
              <AppText
                i18nKey={'PopupOpenCQG'}
                style={styles.txtNoti}></AppText>
              <TouchableOpacity
                onPress={() => navigation.navigate(PACKETCQG)}
                style={styles.containerBtn}>
                <AppText
                  i18nKey={'OpenAccountCQG'}
                  style={styles.txtBtn}></AppText>
              </TouchableOpacity>
            </View>
          )}
        </View>
      )}
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,

    paddingHorizontal: 10,
  },
  item: {
    paddingBottom: 15,
    borderBottomWidth: 1,
    borderBottomColor: '#DBDBDB',
    marginTop: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,
    paddingTop: 5,
  },
  txtNoti: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    marginBottom: 5,
    textAlign: 'center',
  },
  txtNoti1: {
    fontSize: getFontXD(52),
    color: R.colors.orange,
    marginBottom: 5,
    textAlign: 'center',
  },
  txtBig: {
    fontSize: getFontXD(46),
  },
  txtBtn: {
    fontSize: getFontXD(42),
    color: R.colors.white,
    fontWeight: '600',
  },
  containerBtn: {
    paddingVertical: 10,
    paddingHorizontal: 20,
    backgroundColor: R.colors.main,
    borderRadius: 5,
    marginTop: 30,
  },
  btnLeft: {
    backgroundColor: R.colors.main,
    width: WIDTHXD(460),
    alignItems: 'center',
    justifyContent: 'center',
    height: HEIGHTXD(109),
    borderRadius: 5,
  },
  btnRight: {
    backgroundColor: '#E3434F',
    width: WIDTHXD(460),
    alignItems: 'center',
    justifyContent: 'center',
    height: HEIGHTXD(109),
    borderRadius: 5,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {showLoading, hideLoading})(Profile);
