import React from 'react';
import {Alert} from 'react-native';

import FeedbackView from './FeedbackView';
import {connect} from 'react-redux';
import {sendFeedBack} from '../../apis/Functions/General';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import I18n from '../../helper/i18/i18n';
import {useNavigation} from '@react-navigation/native';
import {showAlert, TYPE} from '../../components/DropdownAlert';

const Feedback = (props) => {
  const naviation = useNavigation();
  const onClickSend = async (star_rate, imageAdd, txtInput) => {
    console.log(star_rate, imageAdd, txtInput);
    props.showLoading();
    const res = await sendFeedBack(
      createFormData(imageAdd, {
        star_rate,
        platform: Platform.OS,
        message: txtInput,
      }),
    );
    console.log('upload avatar', res);
    props.hideLoading();
    if (res?.status == 200 && res.data) {
      if (res.data.code == 200) {
        naviation.goBack();
        showAlert(TYPE.SUCCESS, I18n.t('Notification'), res.data.message);
      } else {
        showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
      }
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), 'upload fail');
    }
  };
  const createFormData = (photo, body) => {
    const data = new FormData();
    if (photo) {
      data.append('image_attach_file', {
        name: 'sign_img.jpg',
        type: 'image/jpg',
        uri: Platform.OS === 'android' ? photo : photo.replace('file://', ''),
      });
    }

    Object.keys(body).forEach((key) => {
      data.append(key, body[key]);
    });
    return data;
  };

  return <FeedbackView onClickSend={onClickSend} />;
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {showLoading, hideLoading})(Feedback);
