import React, {useState} from 'react';
import {
  View,
  Text,
  StyleSheet,
  Image,
  TouchableOpacity,
  Alert,
} from 'react-native';
import InputIcon from '../../components/Input/InputIcon';
import {getFontXD, HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import R from '../../assets/R';
import {checkFormatArray} from '../../Config/Functions';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import {connect} from 'react-redux';
import {registorApi, getOTPApi} from '../../apis/Functions/users';
import I18n from '../../helper/i18/i18n';
import AppText from '../../components/AppText';
import {REGISTEROTP} from '../../routers/ScreenNames';
import {showAlert, TYPE} from '../../components/DropdownAlert';

const Registor = (props) => {
  const {navigation} = props;

  const [email, setEmail] = useState('');
  const [password, setPassword] = useState('');
  const [password_confirmation, setPasswordConfirm] = useState('');
  const [sponsor_id, setSponsor_id] = useState('');
  const [phone, setPhone] = useState('');

  const registorClick = async () => {
    const titles = [
      'email',
      I18n.t('Password').toLowerCase(),
      I18n.t('ConfirmPassword').toLowerCase(),
      I18n.t('Phone').toLowerCase(),
    ];
    const index = checkFormatArray([
      email,
      password,
      password_confirmation,
      phone,
    ]);

    if (index === true) {
      props.showLoading();
      const res = await getOTPApi({
        platform: Platform.OS,
        otp_by: email,
        type: 'CUSTOMER_VERIFY',
      });
      props.hideLoading();
      console.log(res);
      if (res.data.code == 200) {
        navigation.navigate(REGISTEROTP, {
          email,
          password,
          password_confirmation,
          phone,
          sponsor_id,
        });
      } else {
        showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
      }
    } else {
      showAlert(
        TYPE.ERROR,
        I18n.t('Notification'),
        I18n.t('Please_fill_in') + titles[index],
      );
    }
  };

  return (
    <View
      style={{
        flex: 1,
        paddingHorizontal: 20,
        paddingTop: 20,
        backgroundColor: 'white',
      }}>
      <InputIcon
        icon={R.images.iconEmail}
        title={'Email'}
        onChangeText={(val) => setEmail(val)}
      />

      <InputIcon
        icon={R.images.iconLock}
        title={'Password'}
        onChangeText={(val) => setPassword(val)}
        isPassWord={true}
      />
      <InputIcon
        icon={R.images.iconLock}
        title={'Confirm_pass'}
        onChangeText={(val) => setPasswordConfirm(val)}
        isPassWord={true}
      />
      <InputIcon
        icon={R.images.iconPhone3}
        title={'Phone'}
        onChangeText={(val) => setPhone(val)}
        isNumber={true}
      />
      <InputIcon
        icon={R.images.iconIntroduct}
        title={'Code_introduce'}
        onChangeText={(val) => setSponsor_id(val)}
      />

      <View
        style={{
          marginTop: 30,
          alignItems: 'center',
        }}>
        <TouchableOpacity onPress={registorClick} style={styles.wrapLogin}>
          <AppText i18nKey={'Register'} style={styles.txtLogin} />
          <Image source={R.images.iconRight1} style={styles.imgIcon} />
        </TouchableOpacity>

        <View style={styles.row}>
          <AppText i18nKey={'Account_already'} style={styles.txtTitle} />
          <TouchableOpacity
            onPress={() => {
              navigation.navigate('LOGIN');
            }}>
            <AppText i18nKey={'Login'} style={styles.txtRegistor} />
          </TouchableOpacity>
        </View>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  forgotView: {
    marginVertical: 20,
    alignItems: 'flex-end',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: '#929292',
  },
  txtLogin: {
    fontSize: getFontXD(48),
    color: 'white',
    fontWeight: '700',
  },
  wrapLogin: {
    width: WIDTHXD(512),
    height: HEIGHTXD(150),
    backgroundColor: '#1C6AF6',
    borderRadius: 30,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  imgIcon: {
    width: WIDTHXD(72),
    height: HEIGHTXD(72),
    marginLeft: 5,
  },
  row: {
    flexDirection: 'row',
    marginTop: 30,
  },
  txtRegistor: {
    fontSize: getFontXD(42),
    color: '#1473E6',
  },
});

const mapStateToProps = (state) => {
  return {};
};
export default connect(mapStateToProps, {
  showLoading,
  hideLoading,
})(Registor);
