import React, {useState} from 'react';
import {
  DeviceEventEmitter,
  Dimensions,
  Keyboard,
  KeyboardAvoidingView,
  Platform,
  ScrollView,
  StyleSheet,
  Text,
  TouchableOpacity,
  TouchableWithoutFeedback,
  View,
} from 'react-native';
import R from '../../../assets/R';
import HeaderBack from '../../../components/Header/HeaderBack';
import TextMulti from '../../../components/Input/TextMulti';
import {useNavigation} from '@react-navigation/native';
import {
  checkFormatArray,
  getFontXD,
  HEIGHTXD,
  toPriceVnd,
  WIDTHXD,
} from '../../../Config/Functions';
import {connect} from 'react-redux';
import {hideLoading, showLoading} from '../../../actions/loadingAction';
import TextMoney from '../../../components/Input/InputMoney';
import I18n from '../../../helper/i18/i18n';
import {
  ENTER_PASSWORD_SMART_OTP,
  SETTINGOTP,
  SMARTOTP,
  CHANGESMARTOTP,
} from '../../../routers/ScreenNames';
import {showAlert, TYPE} from '../../../components/DropdownAlert';
import {confirmAlert} from '../../../components/Aleart';

const WalletDeposit = (props) => {
  const [amount, setAmount] = useState();
  const [notes, setNotes] = useState();
  const navigate = useNavigation();

  const onClick = async () => {
    const titles = [
      I18n.t('AmountOfMoney').toLowerCase(),
      I18n.t('Note').toLowerCase(),
    ];

    const index = checkFormatArray([amount]);
    if (index === true) {
      if (!props.user.smart_otp_status) {
        confirmAlert(
          `${I18n.t('YouHaveNotSettingSmartOTP')}`,
          () => {
            navigate.navigate(CHANGESMARTOTP, {
              TYPE: 'CREATE_SMART_OTP',
              old_password: null,
              isFromTransaction: true,
              setupSmartOTPSuccess: () => {
                navigate.goBack();
                navigate.goBack();
                navigate.navigate(ENTER_PASSWORD_SMART_OTP, {
                  type: 'DEPOSIT',
                  onGoToSmartOTP: (pinCode, otp) =>
                    onGoToSmartOTP(pinCode, otp),
                });
                DeviceEventEmitter.emit('reloadUserInfo');
              },
            });
          },
          `${I18n.t('setting')}`,
        );
      } else {
        navigate.navigate(ENTER_PASSWORD_SMART_OTP, {
          type: 'DEPOSIT',
          onGoToSmartOTP: (pinCode, otp) => onGoToSmartOTP(pinCode, otp),
        });
      }
    } else {
      showAlert(
        TYPE.WARN,
        I18n.t('Notification'),
        I18n.t('Please_fill_in') + titles[index],
      );
    }
  };
  const onGoToSmartOTP = (pinCode, otp) => {
    navigate.goBack();
    navigate.navigate(SMARTOTP, {
      type: 'DEPOSIT',
      amount,
      notes,
      pinCode,
      otp,
    });
  };
  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1, backgroundColor: 'white'}}
      keyboardVerticalOffset={-50}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <View style={{flex: 1}}>
          <HeaderBack title={'InvestmentDeposit'} />
          <ScrollView showsVerticalScrollIndicator={false}>
            <View style={styles.container}>
              <View style={styles.wrapTop}>
                <View style={styles.itemTop}>
                  <Text style={styles.txtTitle}>{I18n.t('Wallet')}</Text>
                  <Text style={styles.txtMoney}>
                    {' '}
                    {props.user.current_money != 0
                      ? toPriceVnd(props.user.current_money)
                      : 0}{' '}
                  </Text>
                </View>
                <View style={{width: 1, backgroundColor: '#DBDBDB'}} />
                <View style={styles.itemTop}>
                  <Text style={styles.txtTitle}>CQG</Text>
                  <Text style={styles.txtMoney}>
                    {' '}
                    {props.user.current_cqg_money != 0
                      ? toPriceVnd(props.user.current_cqg_money)
                      : 0}{' '}
                    đ
                  </Text>
                </View>
              </View>
              <View style={styles.wrapBody}>
                {/* <TextDisable value={'10010101'} title={'Số tài khoản CQG'} /> */}
                <TextMoney
                  onChangeText={(val) => setAmount(val)}
                  title={I18n.t('AmountOfMoney')}
                  value={amount}
                />
                <TextMulti
                  onChangeText={(val) => setNotes(val)}
                  title={I18n.t('Note')}
                  placeholder={I18n.t('noteWithdrawMoney')}
                />
              </View>
            </View>
          </ScrollView>
          <View
            style={{
              paddingVertical: 10,
              justifyContent: 'center',
              alignItems: 'center',
            }}>
            <TouchableOpacity onPress={onClick} style={styles.btnSend}>
              <Text style={styles.txtSend}>{I18n.t('Deposit')}</Text>
            </TouchableOpacity>
          </View>
        </View>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  container: {
    backgroundColor: R.colors.white,
    marginVertical: 10,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  wrapTop: {
    flexDirection: 'row',
    borderBottomWidth: 1,
    borderBottomColor: '#DBDBDB',
  },
  itemTop: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    paddingVertical: 20,
  },
  wrapBody: {
    paddingHorizontal: 10,
    paddingVertical: 20,
  },
  txtMoney: {
    color: '#1C6AF6',
    fontSize: getFontXD(52),
  },
  txtTitle: {
    color: R.colors.black,
    fontSize: getFontXD(42),
  },
  txtSend: {
    fontSize: getFontXD(42),
    color: R.colors.white,
    fontWeight: 'bold',
  },
  btnSend: {
    width: WIDTHXD(400),
    height: HEIGHTXD(100),
    backgroundColor: R.colors.main,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {showLoading, hideLoading})(
  WalletDeposit,
);
