import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import Success from './Tab/Success';
import Watting from './Tab/Watting';
import {getFontXD, HEIGHTXD, WIDTHXD} from '../../../Config/Functions';
import {WALLETDEPOSIT, WALLETWITHDRAW} from '../../../routers/ScreenNames';
import I18n from '../../../helper/i18/i18n';
import AppText from '../../../components/AppText';
import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
import R from '../../../assets/R';
const Tab = createMaterialTopTabNavigator();
import {useNavigation} from '@react-navigation/native';
const Wallet = (props) => {
  const navigate = useNavigation();
  return (
    <View style={{flex: 1}}>
      <HeaderBack isWhite={true} title={'Wallet'} />

      <View style={{flex: 1, backgroundColor: 'red'}}>
        <Tab.Navigator
          initialRouteName="GeneralInfor"
          tabBarOptions={{
            inactiveTintColor: '#929292',
            activeTintColor: '#1473E6',
            labelStyle: {fontSize: getFontXD(36), fontWeight: '700'},
            style: {backgroundColor: 'white'},
          }}>
          <Tab.Screen
            name="Tab1"
            component={Watting}
            options={{tabBarLabel: I18n.t('Waiting')}}
          />
          <Tab.Screen
            name="Tab2"
            component={Success}
            options={{tabBarLabel: I18n.t('Success')}}
          />
        </Tab.Navigator>
      </View>

      <TouchableOpacity
        onPress={() => navigate.navigate(WALLETDEPOSIT)}
        style={styles.btnLeft}>
        <AppText i18nKey={'Deposit'} style={styles.txtTitle}></AppText>
      </TouchableOpacity>
      <TouchableOpacity
        onPress={() => navigate.navigate(WALLETWITHDRAW)}
        style={styles.btnRight}>
        <AppText i18nKey={'Withdraw'} style={styles.txtTitle}></AppText>
      </TouchableOpacity>
    </View>
  );
};

const styles = StyleSheet.create({
  footer: {
    height: 50,
    width: '100%',
    flexDirection: 'row',
    justifyContent: 'space-around',
  },
  btnRight: {
    width: WIDTHXD(400),
    height: HEIGHTXD(120),
    backgroundColor: R.colors.main,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
    position: 'absolute',
    bottom: 20,
    right: 30,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  btnLeft: {
    width: WIDTHXD(400),
    height: HEIGHTXD(120),
    backgroundColor: R.colors.main,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
    position: 'absolute',
    bottom: 20,
    left: 30,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.white,
    fontWeight: 'bold',
  },
});

export default Wallet;
