import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity} from 'react-native';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  toPriceVnd,
  converType,
} from '../../../../Config/Functions';
import R from '../../../../assets/R';
import Block from '../../../../components/Block';
import {useNavigation} from '@react-navigation/native';
import {DETAIL_REQUIRE_MONEY} from '../../../../routers/ScreenNames';
import AppText from '../../../../components/AppText';
const Item = (props) => {
  const {item} = props;
  const navigate = useNavigation();
  return (
    <View style={[styles.container, props.isEnd ? {marginBottom: 60} : {}]}>
      <Block flex={1} row>
        {/* <View style={[styles.wrapLeft, {backgroundColor: item.color}]} />
          <View style={styles.wrapDate}>
            <Text style={styles.txt}>T{item.month}</Text>
            <Text style={styles.txtTitle}>{item.day}</Text>
          </View> */}
        <Block
          style={styles.wrapRight}
          padding={[10, 10]}
          space={'between'}
          flex={1}>
          <View style={styles.rowBet}>
            <Text style={styles.txtTitle}>
              {converType(item.transection_category)}
            </Text>
            <Text
              style={{
                fontSize: getFontXD(42),
                fontWeight: 'bold',
                color: '#FFB721',
              }}>
              {toPriceVnd(item.amount)}
            </Text>
          </View>
          <Text numberOfLines={2} style={styles.txt}>
            {item.comments}
          </Text>
          <View
            style={{
              flexDirection: 'row',
              alignItems: 'center',
              justifyContent: 'space-between',
            }}>
            <Text style={styles.txtDate}>
              {item.transection_date_timestamp}
            </Text>
            {item.status == 0 ? (
              <AppText style={{color: '#FFB721'}} i18nKey={'Waiting'}></AppText>
            ) : (
              <AppText
                style={{color: R.colors.green}}
                i18nKey={'Success'}></AppText>
            )}
          </View>
        </Block>
      </Block>
    </View>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    height: HEIGHTXD(280),
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    marginHorizontal: 10,
    backgroundColor: R.colors.white,
    borderRadius: HEIGHTXD(30),
    marginTop: 10,
  },
  wrapRight: {
    borderLeftColor: R.colors.borderGray,
    borderLeftWidth: 0.7,
  },
  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  wrapDate: {
    justifyContent: 'center',
    paddingLeft: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    fontWeight: '700',
  },
  txt: {
    fontSize: getFontXD(36),
    color: '#363636',
  },
  txtDate: {
    fontSize: getFontXD(39),
    color: '#363636',
  },
  rowBet: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
});
