import React, {useState} from 'react';
import {
  View,
  Text,
  Image,
  TouchableOpacity,
  StyleSheet,
  Alert,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
  TouchableWithoutFeedback,
  Keyboard,
} from 'react-native';
import R from '../../../assets/R';
import {connect} from 'react-redux';

import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
import PickerDate from '../../../components/Picker/PickerDate';
import PickerImg from '../../../components/Picker/PickerImg';
import I18n from '../../../helper/i18/i18n';

import {checkFormatArray, convertTime} from '../../../Config/Functions';
import {showAlert, TYPE} from '../../../components/DropdownAlert';

const GeneralInfor = (props) => {
  const [lastName, setLastName] = useState(props.user.l_name);
  const [firstName, setFirstName] = useState(props.user.f_name);
  const [phone, setPhone] = useState(props.user.phone);
  const [address, setAdress] = useState(props.user.address);
  const [birth, setBirth] = useState(new Date(props.user.birthday));

  console.log('User', props.user);

  const onNextPress = () => {
    const titles = [
      I18n.t('FirstLastName').toLowerCase(),
      I18n.t('Name').toLowerCase(),
      I18n.t('PhoneNumber').toLowerCase(),
      I18n.t('Address').toLowerCase(),
    ];
    const index = checkFormatArray([lastName, firstName, phone, address]);
    if (index === true) {
      props.navigation.navigate('Profile', {
        l_name: lastName,
        f_name: firstName,
        mobile: phone,
        birthday: convertTime(birth),
        address,
      });
    } else {
      showAlert(
        TYPE.WARN,
        I18n.t('Notification'),
        I18n.t('Please_fill_in') + titles[index],
      );
    }
  };

  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-50}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <ScrollView showsVerticalScrollIndicator={false}>
          <View style={{flex: 1, paddingHorizontal: 10, paddingTop: 10}}>
            <View style={{flexDirection: 'row'}}>
              <View style={{flex: 1}}>
                <TextField
                  value={lastName}
                  title={I18n.t('FirstLastName')}
                  onChangeText={(val) => setLastName(val)}
                />
              </View>
              <View style={{width: 20}} />
              <View style={{flex: 1}}>
                <TextField
                  value={firstName}
                  title={I18n.t('Name')}
                  onChangeText={(val) => setFirstName(val)}
                />
              </View>
            </View>
            <TextField
              value={phone}
              isNumber={true}
              title={I18n.t('PhoneNumber')}
              onChangeText={(val) => setPhone(val)}
            />
            <PickerDate
              value={birth}
              onValueChange={(val) => {
                setBirth(val);
              }}
              title={I18n.t('Birth')}
            />

            <TextMulti
              value={address}
              title={I18n.t('Address')}
              onChangeText={(val) => setAdress(val)}
            />
            <TouchableOpacity onPress={onNextPress} style={styles.btnNext}>
              <Image
                style={{width: 30, height: 30}}
                source={R.images.iconRight1}
              />
            </TouchableOpacity>
            <View style={{height: 100}} />
          </View>
        </ScrollView>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  btnNext: {
    borderRadius: 30,
    backgroundColor: '#1473E6',
    width: 50,
    height: 50,
    justifyContent: 'center',
    alignItems: 'center',
    marginTop: 20,
    alignSelf: 'flex-end',
    elevation: 2,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.15,
    shadowRadius: 1.84,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {})(GeneralInfor);
