import React, {useEffect, useRef} from 'react';
import {Alert, View} from 'react-native';

import {connect} from 'react-redux';
import StackNavigation from './routers/StackNavigation';
import Modal from 'react-native-modal';
import {SkypeIndicator} from 'react-native-indicators';
import {enableScreens} from 'react-native-screens';
import NoInternetComponent from './components/NoInternet';
import DropdownAlert from 'react-native-dropdownalert';
import DeviceInfo from 'react-native-device-info';
import R from './assets/R';
import {WIDTHXD, HEIGHTXD, decryptRSAString} from './Config/Functions';
import DropdownManager from './components/DropdownAlert/DropdownManager';
import AsyncStorage from '@react-native-community/async-storage';
import KEY from './assets/AsynStorage';
import I18n, {setLocation} from './helper/i18/i18n';
import {changeLanguage} from './actions/language';
import {RSA_KEY, MY_RSA_KEY} from './Config/constants';
import JSEncrypt from 'jsencrypt';

enableScreens();

const RootView = (props) => {
  useEffect(() => {
    DropdownManager.register(
      dropDownAlertRef.current,
      dropDownAlertLongTimeRef.current,
    );

    setInitLanguage();
  }, []);

  const dropDownAlertRef = useRef(null);
  const dropDownAlertLongTimeRef = useRef(null);
  const setInitLanguage = async () => {
    const laguage = await AsyncStorage.getItem(KEY.LANGUAGE);
    if (laguage) props.changeLanguage(laguage);
    setLocation(I18n, laguage);
  };

  return (
    <>
      <View style={{flex: 1}}>
        <Modal isVisible={props.loadingModal.isVisible}>
          <SkypeIndicator color={'white'} />
        </Modal>
        <StackNavigation />
      </View>
      <DropdownAlert
        inactiveStatusBarBackgroundColor={R.colors.main}
        activeStatusBarBackgroundColor={R.colors.main}
        warnImageSrc={R.images.iconWarn}
        successImageSrc={R.images.iconSuccess}
        errorImageSrc={R.images.iconError}
        titleStyle={{color: '#fff'}}
        messageStyle={{color: '#fff'}}
        updateStatusBar={false}
        closeInterval={1000}
        ref={dropDownAlertRef}
        warnColor={R.colors.orange400}
        defaultContainer={{
          borderBottomRightRadius: WIDTHXD(30),
          borderBottomLeftRadius: WIDTHXD(30),
          paddingTop: HEIGHTXD(30),
          paddingVertical: HEIGHTXD(30),
          paddingHorizontal: WIDTHXD(20),
        }}
      />
      <DropdownAlert
        updateStatusBar={false}
        inactiveStatusBarBackgroundColor={R.colors.colorMain}
        activeStatusBarBackgroundColor={R.colors.colorMain}
        warnImageSrc={R.images.iconWarn}
        successImageSrc={R.images.iconSuccess}
        errorImageSrc={R.images.iconError}
        titleStyle={{color: '#fff'}}
        messageStyle={{color: '#fff'}}
        closeInterval={600000}
        ref={dropDownAlertLongTimeRef}
        warnColor={R.colors.orange400}
        defaultContainer={{
          borderBottomRightRadius: WIDTHXD(30),
          borderBottomLeftRadius: WIDTHXD(30),
          paddingTop: HEIGHTXD(30),
          paddingVertical: HEIGHTXD(30),
          paddingHorizontal: WIDTHXD(20),
        }}
      />
      <NoInternetComponent />
    </>
  );
};

const mapStateToProps = (state) => {
  return {
    loadingModal: state.ModalLoadingReducer,
  };
};

export default connect(mapStateToProps, {})(RootView);
