import React, {useEffect, useState} from 'react';
import {View, Text, Switch, StyleSheet} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
import {getFontXD} from '../../Config/Functions';
import PickerItem from '../../components/Picker/PickerItem';
import AppText from '../../components/AppText';
import {changeLanguage} from '../../actions/language';
import {connect} from 'react-redux';
import AsyncStorage from '@react-native-community/async-storage';
import KEY from '../../assets/AsynStorage';
import I18n, {setLocation} from '../../helper/i18/i18n';
const dataLanguage = [
  {
    value: 'vi',
    name: 'Vietnamese',
  },
  {
    value: 'en',
    name: 'English',
  },
];

const SettingView = (props) => {
  const [isEnabled, setIsEnabled] = useState(true);
  const toggleSwitch = () => setIsEnabled((previousState) => !previousState);

  const [language, setLanguage] = useState();

  useEffect(() => {
    convertLanguage();
  }, []);

  const convertLanguage = () => {
    const temp = dataLanguage.filter((e) => e.value == props.language.language);
    setLanguage(temp[0].name);
  };

  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Setting'} />
      <View style={{flex: 1, padding: 10}}>
        {/* <View style={styles.row}>
          <Text style={styles.txtTitle}>Bật thông báo</Text>
          <Switch
            trackColor={{false: '#DBDBDB', true: '#1C6AF6'}}
            ios_backgroundColor="#767577"
            thumbColor={'#f4f3f4'}
            onValueChange={toggleSwitch}
            value={isEnabled}
          />
        </View> */}

        <View style={styles.row}>
          <AppText i18nKey={'Language'} style={styles.txtTitle} />
          <PickerItem
            width={200}
            defaultValue={language}
            value={language}
            data={dataLanguage}
            onValueChange={(value, items) => {
              setLanguage(items.name);
              props.changeLanguage(items.value);
              AsyncStorage.setItem(KEY.LANGUAGE, items.value);
              setLocation(I18n, items.value);
              props.updateLangue(items.value);
            }}
          />
        </View>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  txtTitle: {
    fontSize: getFontXD(46),
    color: '#001C51',
  },

  row: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginBottom: 20,
  },
});

const mapStateToProps = (state) => {
  return {
    language: state.languageReducer,
  };
};

export default connect(mapStateToProps, {changeLanguage})(SettingView);
