import React, {useState, useEffect} from 'react';
import {
  Text,
  View,
  Modal,
  TouchableOpacity,
  FlatList,
  StyleSheet,
  TextInput,
  ActivityIndicator,
} from 'react-native';
import _ from 'lodash';
import AntDesign from 'react-native-vector-icons/AntDesign';
import R from '../../assets/R';
import {
  HEIGHTXD,
  WIDTHXD,
  getFontXD,
  getWidth,
  getHeight,
} from '../../Config/Functions';
import I18n from '../../helper/i18/i18n';
import ItemBank from './ItemBank';
import {SafeAreaView} from 'react-native-safe-area-context';

const SelectBankModal = (props) => {
  const [modalVisible, setModalVisible] = useState(false);
  const [valueSearch, setValueSearch] = useState('');
  const [result, setResult] = useState(props.data);
  const [keySearch, setKeySearch] = useState('');
  useEffect(() => {
    setResult(props.data);
  }, [props.data]);
  const localFilter = (data, allowFields = [], search_text) => {
    if (!data) return [];
    if (!search_text || search_text === '') return data;

    let result = [];
    data.map((item) => {
      if (!allowFields) {
        result.push(item);
      } else {
        let added = false;
        allowFields.map((param) => {
          if (
            !added &&
            (item[param + ''] + '')
              .toLowerCase()
              .includes(search_text.toLowerCase())
          ) {
            result.push(item);
            added = true;
          }
        });
      }
    });
    return result;
  };
  const _onSearch = async (keySearch) => {
    const data = props.data
      ? localFilter(props.data, ['code', 'name'], keySearch).map((x) => ({
          id: x.id,
          code: x.code,
          name: x.name,
          logo: x.logo,
        }))
      : [];

    // remove duplicate
    let result = [];
    data.map((item) => {
      let exists = result.filter((x) => x.id === item.id);
      if (!exists || exists.length === 0) result.push(item);
    });
    setResult(result);
  };
  const _onPressItem = (item) => {
    props.onPressItem(item);
    setValueSearch(item ? item.name : '');
    setModalVisible(false);
  };

  return (
    <View>
      <TouchableOpacity
        style={[styles.buttonShowModal]}
        onPress={() => {
          setModalVisible(true);
          setKeySearch('');
          _onSearch(keySearch);
        }}>
        <View style={styles.flexRowJustifyBetween}>
          <Text
            style={[styles.txtTitle, {flex: 1, flexWrap: 'wrap'}]}
            numberOfLines={1}
            ellipsizeMode="tail">
            {valueSearch.trim()}
          </Text>
          <View>
            {valueSearch === '' ? (
              <TouchableOpacity
                onPress={() => {
                  setModalVisible(true);
                  _onSearch(keySearch);
                }}
                hitSlop={{left: WIDTHXD(50), right: WIDTHXD(50)}}>
                <AntDesign
                  name="search1"
                  size={WIDTHXD(43)}
                  color={R.colors.iconGray}
                />
              </TouchableOpacity>
            ) : (
              <TouchableOpacity
                onPress={() => {
                  _onPressItem(null);
                }}
                hitSlop={{left: WIDTHXD(50), right: WIDTHXD(50)}}>
                <AntDesign
                  name="close"
                  size={WIDTHXD(43)}
                  color={R.colors.iconGray}
                />
              </TouchableOpacity>
            )}
          </View>
        </View>
      </TouchableOpacity>

      <Modal animated={true} animationType="fade" visible={modalVisible}>
        <SafeAreaView>
          <View style={styles.overViewModal}>
            <View style={[styles.container]}>
              <View style={styles.viewTitle}>
                <Text style={[styles.title]}>{props.title}</Text>
                <TouchableOpacity
                  style={styles.btClose}
                  onPress={() => setModalVisible(false)}>
                  <AntDesign
                    name="close"
                    size={WIDTHXD(48)}
                    color={R.colors.black}
                  />
                </TouchableOpacity>
              </View>
              <View style={styles.viewContent}>
                <View style={styles.inputSearch}>
                  <TextInput
                    style={styles.input}
                    value={keySearch}
                    placeholder={I18n.t('Search')}
                    placeholderTextColor={R.colors.color777}
                    onChangeText={(keySearch) => {
                      setKeySearch(keySearch);
                      _onSearch(keySearch);
                    }}
                  />
                  <AntDesign
                    name="search1"
                    size={WIDTHXD(40)}
                    color={R.colors.gray}
                    style={{position: 'absolute', left: WIDTHXD(28)}}
                  />
                </View>
                {!_.isEmpty(result) ? (
                  <View style={styles.viewResult}>
                    <FlatList
                      data={result}
                      extraData={result}
                      style={styles.flatlist}
                      renderItem={({item, index}) => (
                        <ItemBank
                          item={item}
                          isEndItem={index == result.length - 1}
                          onPress={(item) => _onPressItem(item)}
                        />
                      )}
                    />
                  </View>
                ) : (
                  <Text style={styles.txtEmpty}>
                    {I18n.t('NullDataSearch')}
                  </Text>
                )}
              </View>
            </View>
          </View>
        </SafeAreaView>
      </Modal>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    backgroundColor: R.colors.white,
    width: getWidth(),
    height: getHeight(),
  },

  txtEmpty: {
    textAlign: 'center',
    color: R.colors.black,
    fontSize: getFontXD(36),
    marginTop: HEIGHTXD(48),
  },
  viewTitle: {
    width: getWidth(),
    height: HEIGHTXD(85),
    marginTop: WIDTHXD(30),
    flexDirection: 'row',
    justifyContent: 'center',
    position: 'relative',
  },
  txtTitle: {
    marginRight: WIDTHXD(24),
    color: R.colors.black,
    fontSize: getFontXD(42),
  },
  viewContent: {
    marginTop: WIDTHXD(30),
    marginBottom: WIDTHXD(36),
    paddingHorizontal: WIDTHXD(46),
  },
  inputSearch: {
    flexDirection: 'row',
    position: 'relative',
    alignItems: 'center',
  },
  viewResult: {
    marginTop: WIDTHXD(37),
    paddingBottom: WIDTHXD(54),
  },
  flatlist: {
    width: getWidth(),
    marginBottom: HEIGHTXD(300),
  },
  input: {
    height: WIDTHXD(110),
    width: getWidth() - WIDTHXD(90),
    borderRadius: WIDTHXD(20),
    backgroundColor: R.colors.gray5,
    fontSize: getFontXD(35),
    paddingLeft: WIDTHXD(90),
    paddingRight: WIDTHXD(90),
    color: R.colors.black,
  },
  flexRow: {
    flexDirection: 'row',
  },
  title: {
    width: getWidth(),
    textAlign: 'center',
    alignItems: 'center',
    fontSize: getFontXD(48),
    color: R.colors.black,
  },
  buttonShowModal: {
    justifyContent: 'center',
    height: HEIGHTXD(109),
    color: 'black',
    borderRadius: 7,
    borderWidth: 0.7,
    borderColor: '#DBDBDB',
    fontSize: getFontXD(42),
    paddingVertical: 5,
    paddingHorizontal: 10,
    backgroundColor: 'white',
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  flexRowJustifyBetween: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    paddingHorizontal: WIDTHXD(5),
  },
  overViewModal: {
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#rgba(0,0,0,0.7)',
  },
  btClose: {
    alignSelf: 'center',
    position: 'absolute',
    left: WIDTHXD(48),
    width: WIDTHXD(48),
    height: WIDTHXD(48),
  },
  btItem: {
    paddingVertical: WIDTHXD(6),
    // paddingBottom: WIDTHXD(18),
    justifyContent: 'center',
    borderBottomWidth: WIDTHXD(1),
    borderBottomColor: R.colors.borderD4,
  },
  txtResult: {
    paddingLeft: WIDTHXD(28),
    paddingRight: WIDTHXD(28),
    lineHeight: HEIGHTXD(100),
    // width: '100%'
    // textAlign: 'center'
  },
  loading: {
    alignSelf: 'center',
    marginTop: 24,
  },
});
export default React.memo(SelectBankModal);
