import React from 'react';
import {View, Text, StyleSheet, Image, TouchableOpacity} from 'react-native';
import HeaderDrawer from '../../components/Header/HeaderDrawer';
import {WIDTHXD, HEIGHTXD} from '../../Config/Functions';
import R from '../../assets/R';
import AppText from '../../components/AppText';
import {useNavigation} from '@react-navigation/native';
import {
  USERINFOR,
  PAYMENTS,
  ROSE,
  BONUSTEAM,
  MYGROUP,
  AccountVerification,
  PROFILE,
} from '../../routers/ScreenNames';

const AccountView = (props) => {
  const navigate = useNavigation();

  return (
    <View>
      <HeaderDrawer title={'Account'} />
      <View style={styles.container}>
        <TouchableOpacity
          onPress={() => navigate.navigate(PROFILE)}
          style={styles.containerItem}>
          <Image source={R.images.iconUser} style={styles.imgIcon} />
          <AppText i18nKey={'MyProfile'}> </AppText>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => navigate.navigate(AccountVerification)}
          style={styles.containerItem}>
          <Image source={R.images.iconUserAccuracy} style={styles.imgIcon} />
          <AppText i18nKey={'VerifyAccount'}> </AppText>
        </TouchableOpacity>

        <TouchableOpacity
          onPress={() => navigate.navigate(PAYMENTS)}
          style={styles.containerItem}>
          <Image source={R.images.iconList} style={styles.imgIcon} />
          <AppText i18nKey={'Payments'}> </AppText>
        </TouchableOpacity>

        <TouchableOpacity
          onPress={() => navigate.navigate(ROSE)}
          style={styles.containerItem}>
          <Image source={R.images.iconRose} style={styles.imgIcon} />
          <AppText i18nKey={'Rose'}> </AppText>
        </TouchableOpacity>

        <TouchableOpacity
          onPress={() => navigate.navigate(BONUSTEAM)}
          style={styles.containerItem}>
          <Image source={R.images.iconWallet} style={styles.imgIcon} />
          <AppText i18nKey={'TeamBonus'}> </AppText>
        </TouchableOpacity>

        <TouchableOpacity
          onPress={() => navigate.navigate(MYGROUP)}
          style={styles.containerItem}>
          <Image source={R.images.moneyteam} style={styles.imgIcon} />
          <AppText i18nKey={'MyPartner'}> </AppText>
        </TouchableOpacity>
      </View>
    </View>
  );
};

export default AccountView;

const styles = StyleSheet.create({
  container: {
    flexDirection: 'row',
    paddingHorizontal: 30,

    justifyContent: 'space-between',
    flexWrap: 'wrap',
  },
  containerItem: {
    width: WIDTHXD(450),
    height: HEIGHTXD(450),
    backgroundColor: 'white',
    marginTop: 20,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 2.84,
    elevation: 3,
  },
  imgIcon: {
    width: WIDTHXD(216),
    height: HEIGHTXD(216),
    marginBottom: 10,
    resizeMode: 'contain',
  },
});
