import React, {useEffect, useState} from 'react';
import {
    View,
    Text,
    Modal,
    TouchableOpacity,
    StyleSheet,
    Image,
    TouchableWithoutFeedback,
    Linking, Platform,
} from 'react-native';
import R from '../../assets/R';
import {getFontXD, getHeight, getWidth, HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import I18n from '../../helper/i18/i18n';
import DeviceInfo from 'react-native-device-info';
import {getNewestVersionInfo} from '../../apis/Functions/users';
import InAppUpdate from '../../helper/InAppUpdate';

const VersionChecker = (props) => {
    const [visible, setVisible] = useState(false);
    const [isForceUpdate, setIsForceUpdate] = useState(false);
    const [version, setVersion] = useState('1.0');
    useEffect(() => {
        checkVersion();
    }, []);

    const checkVersion = async () => {
        const verCurrent = DeviceInfo.getVersion();
        const res = await getNewestVersionInfo({
            platform: Platform.OS,
        });
        if ((res.data.code = 200 && res.data.data)) {
            console.log(res);
            if (res.data.data[0].version_name !== verCurrent || res.data.data[0].build.toString() !== DeviceInfo.getBuildNumber) {
                setVersion(res.data.data[0].version_name);
                setVisible(true);
                setIsForceUpdate(res.data.data[0].is_require_update == 0 ? false : true);
            }
        }
    };
    const setVisibleModal = (visible, version, isForceUpdate) => {
        setVisible(visible);
        setVersion(version);
        setIsForceUpdate(isForceUpdate);
    };

    const _renderDivider = () => <View style={styles.dividerStyle}/>;

    const onOutsidePressed = () => {
        setVisible(false);
    };

    const onUpdatePressed = async () => {
        try {
            if (Platform.OS === 'ios') {
                Linking.openURL('itms-apps://itunes.apple.com/us/app/dcv-invest/id1556621903?l=id');
            } else {
                // try {
                //     InAppUpdate.checkUpdate()
                // } catch(e) {
                //     console.log(e)
                // }
                Linking.openURL('https://play.google.com/store/apps/details?id=com.dcv.invest');
            }
        } catch (error) {
        }
    };

    const onRequestClose = () => null;

    const renderBackdrop = () => {
        return (
            <View
                style={{
                    backgroundColor: 'rgba(0,0,0,0.30)',
                    // backgroundColor: 'red',
                    position: 'absolute',
                    top: 0,
                    bottom: 0,
                    left: 0,
                    right: 0,

                    width: getWidth(),
                    height: getHeight(),
                }}
            />
        );
    };

    const cancelUpdate = () => {
        setVisible(false);
    };

    return (
        <Modal
            onRequestClose={() => onRequestClose()}
            transparent
            animationType="fade"
            style={{position: 'absolute'}}
            visible={visible}
        >
            {renderBackdrop()}
            <View pointerEvents="box-none" style={styles.containerStyle}>
                <View style={styles.imageUpgradeContainer} zIndex={100}>
                    <Image
                        source={R.images.iconUpgrade}
                        style={[styles.imageUpgradeStyle, {tintColor: R.colors.main}]}/>
                </View>

                <View style={styles.contentContainerStyle}>
                    <Text style={styles.titleStyle}>{I18n.t('Update')}</Text>
                    <Text style={styles.versionLabelStyle}>
                        {I18n.t('Version')}
                        {': '}
                        {version}
                    </Text>

                    <Text style={styles.descStyle}>{I18n.t('UpdateDescription')}</Text>

                    {_renderDivider()}
                    {isForceUpdate ?
                        <TouchableOpacity onPress={() => onUpdatePressed()} style={styles.notNowContainerStyle}>
                            <Text
                                style={[styles.textNotNowStyle, {color: R.colors.main}]}>{I18n.t('Update')}</Text>
                        </TouchableOpacity>
                        :
                        <View style={[styles.notNowContainerStyle, {
                            flexDirection: 'row',
                            marginHorizontal: WIDTHXD(100),
                        }]}>
                            <TouchableOpacity onPress={() => cancelUpdate()}
                                              style={[styles.btnButton, {paddingRight: WIDTHXD(60) }]}>
                                <Text
                                    style={[styles.textNotNowStyle, {color: R.colors.color777, textAlign: 'right'}]}>{I18n.t('Cancel')}</Text>
                            </TouchableOpacity>
                            <View style={styles.dividerStyleVertical}></View>
                            <TouchableOpacity onPress={() => onUpdatePressed()}
                                              style={[styles.btnButton, {paddingLeft: WIDTHXD(60)}]}>
                                <Text
                                    style={[styles.textNotNowStyle, {color: R.colors.main, textAlign: 'left'}]}>{I18n.t('Update')}</Text>
                            </TouchableOpacity>
                        </View>
                    }
                </View>
            </View>
        </Modal>
    );
};

const styles = StyleSheet.create({
    imageUpgradeStyle: {
        width: 50,
        height: 50,
        tintColor: R.colors.primaryColor,
    },
    imageUpgradeContainer: {
        width: 80,
        height: 80,
        borderRadius: 40,
        backgroundColor: 'white',
        alignItems: 'center',
        justifyContent: 'center',
    },
    containerStyle: {
        flex: 1,
        width: getWidth() * 0.8,
        alignSelf: 'center',
        alignItems: 'center',
        justifyContent: 'center',
    },

    contentContainerStyle: {
        marginTop: -40,
        paddingTop: 40,
        width: getWidth() * 0.9,
        backgroundColor: 'white',
        alignItems: 'center',
        justifyContent: 'center',
        borderRadius: 15,
    },

    logoStyle: {
        width: 65,
        height: 65,
        marginVertical: 20,
    },
    titleStyle: {
        fontWeight: '600',
        fontSize: 20,
        color: 'black',
        paddingHorizontal: 8,
        textAlign: 'center',
    },

    versionLabelStyle: {
        fontSize: 14,
        color: R.colors.grey600,
        marginTop: 5,
        marginBottom: 15,
        paddingHorizontal: 8,
        textAlign: 'center',
    },

    descStyle: {
        fontSize: getFontXD(46),
        color: R.colors.grey900,
        marginBottom: 20,
        paddingHorizontal: 10,
        textAlign: 'center',
    },
    notNowContainerStyle: {
        height: HEIGHTXD(160),
        width: '100%',
        alignItems: 'center',
        justifyContent: 'center',
    },

    btnButton: {
        flex: 1,
    },

    textNotNowStyle: {
        fontSize: getFontXD(46),
        width: '100%',
        textAlign: 'center',
        color: R.colors.primaryColor,
    },

    starContainer: {
        flexDirection: 'row',
        width: '100%',
        justifyContent: 'center',
        alignItems: 'center',
        height: 45,
    },
    dividerStyle: {
        height: 0.5,
        width: '100%',
        backgroundColor: R.colors.borderC,
    },
    dividerStyleVertical: {
        height: HEIGHTXD(160),
        width: 0.5,
        backgroundColor: R.colors.borderC,
    },
});

export default VersionChecker;
