import React, {Component} from 'react';
import {View, Text, StatusBar, SafeAreaView} from 'react-native';
import {getFontXD, HEIGHT, WIDTHXD} from '../../Config/Functions';
import DueDate from './DueDate/DueDate';
import Escrow from './Escrow/Escrow';
import PriceList from './PriceList/PriceList';
import TimeTransaction from './TimeTransaction/TimeTransaction';
import I18n from '../../helper/i18/i18n';

import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
const Tab = createMaterialTopTabNavigator();
import HeaderDrawer from '../../components/Header/HeaderDrawer';

const NewFeed = (props) => {
  return (
    <View style={{flex: 1}}>
      <HeaderDrawer title={'Tradding'} isWhite={true} />
      <View style={{flex: 1, backgroundColor: 'white'}}>
        <Tab.Navigator
          initialRouteName="PriceList"
          swipeEnabled={false}
          tabBarOptions={{
            scrollEnabled: true,
            inactiveTintColor: '#929292',
            activeTintColor: '#1473E6',
            labelStyle: {fontSize: getFontXD(36)},
            style: {backgroundColor: 'white'},
          }}>
          <Tab.Screen
            name="PriceList"
            component={PriceList}
            options={{tabBarLabel: 'Bảng phí'}}
          />
          <Tab.Screen
            name="TimeTransaction"
            component={TimeTransaction}
            options={{tabBarLabel: 'Thời gian GD'}}
          />
          <Tab.Screen
            name="Escrow"
            component={Escrow}
            options={{tabBarLabel: 'Ký quỹ'}}
          />
          <Tab.Screen
            name="DueDate"
            component={DueDate}
            options={{tabBarLabel: 'Lịch đáo hạn'}}
          />
        </Tab.Navigator>
      </View>
    </View>
  );
};

export default NewFeed;
