import React, {useEffect, useState} from 'react';
import {View, ScrollView, StyleSheet, Alert} from 'react-native';
import R from '../../../../../assets/R';
import GeneralInfo from './ItemView/GeneralInfo';
import TimeTransaction from './ItemView/TimeTransaction';
import PriceInfo from './ItemView/PriceInfo';
import {HEIGHTXD} from '../../../../../Config/Functions';
import {showLoading, hideLoading} from '../../../../../actions/loadingAction';
import {getContractDescription} from '../../../../../apis/Functions/Transaction';
import I18n from '../../../../../helper/i18/i18n';
import {showAlert, TYPE} from '../../../../../components/DropdownAlert';

const ContractDescription = (props) => {
  const [contractDescription, setContractDescription] = useState(null);
  useEffect(() => {
    async function fetchData() {
      showLoading();
      const res = await getContractDescription(props.route.params.id);
      if (res.status === 200 && res.data.code === 200) {
        console.log('Data', res.data.data);
        setContractDescription(res.data.data);
      } else {
        showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
      }

      hideLoading();
    }
    fetchData();
  }, [props.route.params.id]);
  return (
    <ScrollView style={styles.container} showsVerticalScrollIndicator={false}>
      <View style={{marginBottom: HEIGHTXD(100)}}>
        <GeneralInfo contractDescription={contractDescription} />
        <TimeTransaction contractDescription={contractDescription} />
        <PriceInfo contractDescription={contractDescription} />
      </View>
    </ScrollView>
  );
};
export default ContractDescription;

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.colorBackground,
    paddingTop: HEIGHTXD(30),
  },
});
