import React from 'react';
import {
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  Image,
  Alert,
} from 'react-native';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  toPriceVnd,
} from '../../../Config/Functions';
import R from '../../../assets/R';
import Block from '../../../components/Block';
import I18n from '../../../helper/i18/i18n';

const Item = (props) => {
  const {item, isEndItem} = props;
  console.log('sss', item);
  return (
    <View
      style={[styles.container, isEndItem && {marginBottom: HEIGHTXD(100)}]}>
      <TouchableOpacity onPress={() => props.onPress(item)}>
        <Block flex={1} row>
          <Image source={{uri: item.image_path}} style={styles.imgIcon} />
          <Block padding={[0, WIDTHXD(40)]} space={'between'} flex={1}>
            <View
              style={{
                flexDirection: 'row',
              }}>
              <Text
                numberOfLines={2}
                style={[styles.txtBlack, {flexWrap: 'wrap', flex: 1}]}
                numberOfLines={1}
                ellipsizeMode="tail">
                {item.name}
              </Text>
              <Text style={styles.txtMoney}>{toPriceVnd(item.fee)}</Text>
            </View>
            <Text style={styles.txt}>
              {I18n.t('code')}: {item.code}
            </Text>
            <Text style={styles.txt}>{item.category.name}</Text>
          </Block>
        </Block>
      </TouchableOpacity>
    </View>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    paddingVertical: HEIGHTXD(40),
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    backgroundColor: R.colors.white,
    borderRadius: HEIGHTXD(30),
    marginVertical: HEIGHTXD(15),
    marginHorizontal: WIDTHXD(30),
  },

  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    fontWeight: 'bold',
  },
  txt: {
    fontSize: getFontXD(36),
    color: 'black',
  },
  rowBet: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  txtBlack: {
    fontSize: getFontXD(46),
    color: 'black',
  },
  imgIcon: {
    width: WIDTHXD(178),
    height: WIDTHXD(178),
    resizeMode: 'cover',
    marginLeft: WIDTHXD(35),
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: R.colors.main,
  },
});
