import React, {useState} from 'react';
import {
    View,
    Text,
    FlatList,
    StyleSheet,
    TouchableOpacity,
    ScrollView,
} from 'react-native';

import HeaderDrawer from '../../../components/Header/HeaderDrawer';
import Item from './Item';
import {getFontXD, HEIGHTXD} from '../../../Config/Functions';
import AppText from '../../../components/AppText';
import {PRODUCTDETAIL} from '../../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';

const EscrowView = (props) => {
    const {onRefresh, isRefresh, onLoadMore, setFilterId, filters, filterId, data} = props;
    const navigate = useNavigation();

    return (
        <View style={{flex: 1}}>
            <View style={styles.headerContainer}>
                <ScrollView horizontal showsHorizontalScrollIndicator={false}>
                    {filters.map((e) => (
                        <TouchableOpacity
                            key={e.id}
                            onPress={() => setFilterId(e.id)}
                            style={[
                                styles.itemFillter,
                                filterId == e.id ? {borderColor: '#1473E6'} : null,
                            ]}>
                            <Text
                                style={[
                                    styles.txtFillter,
                                    filterId == e.id ? {color: '#1473E6'} : {},
                                ]}>{e.name}</Text>
                        </TouchableOpacity>
                    ))}
                </ScrollView>
            </View>

            {data.length == 0 && !isRefresh ? (
                <View style={{justifyContent: 'center', alignItems: 'center', flex: 1}}>
                    <AppText
                        i18nKey={'NoData'}
                        style={{
                            fontSize: 18,
                            fontWeight: 'bold',
                        }}></AppText>
                </View>
            ) : (
                <FlatList
                    style={{marginTop: HEIGHTXD(15)}}
                    keyExtractor={(item) => item.id}
                    data={data}
                    refreshing={isRefresh}
                    onRefresh={onRefresh}
                    onEndReachedThreshold={0.01}
                    onEndReached={(info) => {
                        onLoadMore();
                    }}
                    renderItem={({item, index}) => <Item item={item}
                                                         isEndItem={index == (data.length - 1)}
                                                         onPress={(item) => navigate.navigate(PRODUCTDETAIL, {id: item.commoditiy.id, name: item.commoditiy.name})}/>}
                />
            )}
        </View>
    );
};

const styles = StyleSheet.create({
    headerContainer: {
        paddingVertical: 10,
        backgroundColor: 'white',
        flexDirection: 'row',
        alignItems: 'center',
        paddingHorizontal: 10,
    },
    itemFillter: {
        borderRadius: 10,
        paddingVertical: 5,
        paddingHorizontal: 10,
        borderWidth: 1,
        borderColor: '#929292',
        justifyContent: 'center',
        alignItems: 'center',
        marginRight: 10,
    },
    txtFillter: {
        fontSize: getFontXD(36),
        color: '#929292',
        fontWeight: 'bold',
    },
    txtTitle: {
        fontSize: getFontXD(46),
        fontWeight: 'bold',
    },
});

export default EscrowView;
