import React, {useState, useEffect} from 'react';
import {
  View,
  TouchableOpacity,
  Text,
  LayoutAnimation,
  StyleSheet,
} from 'react-native';
import R from '../../../assets/R';

import Ionicons from 'react-native-vector-icons/Ionicons';
import {
  getFontXD,
  getLineHeightXD,
  HEIGHTXD,
  toPriceVnd,
  WIDTHXD,
} from '../../../Config/Functions';
import I18n from '../../../helper/i18/i18n';
import TextField from '../../../components/TextField';
import {RadioBuySale} from '../../../Config/constants';

const ItemCalculator = (props) => {
  const [expanded, setExpanded] = useState(true);
  const changeLayout = () => {
    LayoutAnimation.configureNext({
      duration: 500,
      create: {
        type: LayoutAnimation.Types.spring,
        property: LayoutAnimation.Properties.scaleY,
        springDamping: 1.7,
      },
      update: {
        type: LayoutAnimation.Types.spring,
        springDamping: 1.7,
      },
    });
    setExpanded(!expanded);
  };
  console.log(props.item);

  return (
    <View
      style={[
        styles.container,
        {marginBottom: props.isLastItem ? HEIGHTXD(100) : HEIGHTXD(30)},
      ]}>
      <TouchableOpacity
        onPress={() => changeLayout()}
        style={[
          styles.flexTitle,
          {
            borderBottomWidth: expanded === true ? 0.3 : 0,
            paddingHorizontal: WIDTHXD(30),
          },
        ]}>
        <Text style={styles.title}>{props.item.name}</Text>
        {expanded === true ? (
          <Ionicons
            name="chevron-up"
            size={WIDTHXD(50)}
            style={{marginRight: WIDTHXD(25)}}
            color={R.colors.iconGray}
          />
        ) : (
          <Ionicons
            name="chevron-down"
            size={WIDTHXD(50)}
            style={{marginRight: WIDTHXD(25)}}
            color={R.colors.iconGray}
          />
        )}
      </TouchableOpacity>
      {expanded ? (
        <View style={{paddingVertical: HEIGHTXD(20)}}>
          <TextField
            title={I18n.t('Status')}
            content={I18n.t(props.item.transaction_type)}
            color={
              props.item.transaction_type == 'SELL_OUT'
                ? R.colors.red2
                : R.colors.green
            }
          />
          <TextField
            title={I18n.t('SlotNumber')}
            content={props.item.lot_number}
          />
          <TextField
            title={`${I18n.t('ProfitLoss')} (USD)`}
            content={
              props.item.profit.USD ? toPriceVnd(props.item.profit.USD) : '0'
            }
          />
          <TextField
            title={`${I18n.t('ProfitLoss')} (VNĐ)`}
            content={
              props.item.profit.VND ? toPriceVnd(props.item.profit.VND) : '0'
            }
          />
        </View>
      ) : null}
    </View>
  );
};
export default ItemCalculator;
const styles = StyleSheet.create({
  container: {
    backgroundColor: R.colors.white,
    borderColor: R.colors.borderGray,
    borderWidth: 0.3,
    marginHorizontal: WIDTHXD(40),
    marginBottom: HEIGHTXD(30),
  },
  flexTitle: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingVertical: HEIGHTXD(20),
    borderBottomColor: R.colors.borderGray,
  },
  title: {
    fontSize: getFontXD(36),
    lineHeight: getLineHeightXD(56),
    color: R.colors.black,
  },
});
