import React, {Component} from 'react';
import {
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  FlatList,
  ScrollView,
} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import {
  getFontXD,
  HEIGHTXD,
  toPriceVnd,
  WIDTHXD,
} from '../../../Config/Functions';
import I18n from '../../../helper/i18/i18n';
import PickerItem from '../../../components/Picker/PickerItem';
import R from '../../../assets/R';
import RadioForm from 'react-native-simple-radio-button';
import {RadioBuySale} from '../../../Config/constants';
import TextMoney from '../../../components/Input/InputMoney';
import ItemCalculator from './ItemCalculator';
import AppText from '../../../components/AppText';

const CalculatorProfitLossView = (props) => {
  return (
    <View style={{flex: 1, flexDirection: 'column', backgroundColor: 'white'}}>
      <HeaderBack title={'CalculatorProfitLoss'} isWhite={true} />
      <ScrollView>
        <View
          style={{
            paddingHorizontal: WIDTHXD(60),
            paddingVertical: HEIGHTXD(60),
          }}>
          <Text style={styles.textTitle}>{I18n.t('Product')}</Text>
          <PickerItem
            data={props.dataProduct}
            onValueChange={(value, item) => {
              props.setProduct(item);
            }}
            defaultValue={props.product?.name}
            iconSize={WIDTHXD(40)}
            iconColor={R.colors.black}
          />
          <AppText style={[styles.textTitle, {marginTop: HEIGHTXD(30)}]}>
            {I18n.t('Tradding')}
          </AppText>
          <View style={{width: WIDTHXD(600), height: HEIGHTXD(85)}}>
            <RadioForm
              radio_props={RadioBuySale}
              labelStyle={{fontSize: getFontXD(42)}}
              formHorizontal={true}
              style={styles.row}
              initial={0}
              buttonSize={WIDTHXD(30)}
              onPress={(value) => {
                props.setTransactionType(value);
              }}
            />
          </View>
          <TextMoney
            onChangeText={(val) => {
              props.setLotNumber(val);
            }}
            title={I18n.t('LotTransactionNumber')}
            value={toPriceVnd(props.lotTransactionNumber)}
            titleStyle={{marginTop: HEIGHTXD(20), fontSize: getFontXD(39)}}
          />
          <TextMoney
            onChangeText={(val) => {
              props.setOpenPrice(val);
            }}
            title={I18n.t('OpenPrice')}
            value={toPriceVnd(props.openPrice)}
            titleStyle={{marginTop: HEIGHTXD(20), fontSize: getFontXD(39)}}
          />
          <TextMoney
            onChangeText={(val) => {
              props.setCloseStatusPrice(val);
            }}
            title={I18n.t('CloseStatusPrice')}
            value={toPriceVnd(props.closeStatusPrice)}
            titleStyle={{marginTop: HEIGHTXD(20), fontSize: getFontXD(39)}}
          />
          <View
            style={{
              width: '100%',
              flexDirection: 'row',
              justifyContent: 'center',
              alignItems: 'center',
              marginTop: HEIGHTXD(50),
            }}>
            <TouchableOpacity
              onPress={() => {
                props.onDelete();
              }}
              style={[
                styles.btn,
                {backgroundColor: R.colors.red2, marginRight: WIDTHXD(72)},
              ]}>
              <Text style={styles.txtButton}>{I18n.t('Delete')}</Text>
            </TouchableOpacity>
            <TouchableOpacity
              onPress={() => {
                props.onCalculator();
              }}
              style={styles.btn}>
              <Text style={styles.txtButton}>{I18n.t('Caculate')}</Text>
            </TouchableOpacity>
          </View>
        </View>
        <FlatList
          style={{paddingBottom: HEIGHTXD(15), backgroundColor: R.colors.white}}
          keyExtractor={(item) => item}
          data={props.dataCalculator}
          renderItem={({item, index}) => (
            <ItemCalculator
              item={item}
              isLastItem={index === props.dataCalculator.length - 1}
            />
          )}
        />
      </ScrollView>
    </View>
  );
};
const styles = StyleSheet.create({
  viewInput: {
    marginHorizontal: WIDTHXD(36),
    marginTop: WIDTHXD(69),
    marginBottom: WIDTHXD(44),
    borderWidth: 0.3,
    borderColor: '#707070',
    paddingHorizontal: WIDTHXD(24),
    paddingVertical: WIDTHXD(24),
  },
  textTitle: {
    fontSize: getFontXD(39),
    color: R.colors.color777,
  },
  row: {
    height: HEIGHTXD(109),
    width: '100%',
    justifyContent: 'space-between',
    marginVertical: 5,
  },
  btn: {
    width: WIDTHXD(428),
    height: HEIGHTXD(120),
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.main,
    borderRadius: 5,
  },
  txtButton: {
    color: R.colors.white,
    fontSize: getFontXD(48),
  },
});
export default CalculatorProfitLossView;
