import React, {useEffect, useState} from 'react';
import CalculatorProfitLossView from './CalculatorProfitLossView';
import {RadioBuySale} from '../../../Config/constants';
import I18n from '../../../helper/i18/i18n';
import {checkFormatArray} from '../../../Config/Functions';
import {showAlert, TYPE} from '../../../components/DropdownAlert';
import {
  getTransactionListByCategory,
  getProfitLost,
} from '../../../apis/Functions/Transaction';
import {Platform} from 'react-native';
import {showLoading, hideLoading} from '../../../actions/loadingAction';
import {connect} from 'react-redux';

const CalculatorProfitLoss = (props) => {
  const [dataProduct, setDataProduct] = useState([]);
  const [product, setProduct] = useState(null);
  const [transactionType, setTransactionType] = useState(RadioBuySale[0].value);
  const [dataCalculator, setDataCalculator] = useState([]);
  const [lotTransactionNumber, setLotTransactionNumber] = useState(null);
  const [openPrice, setOpenPrice] = useState(null);
  const [closeStatusPrice, setCloseStatusPrice] = useState(null);
  useEffect(() => {
    getProductData();
  }, []);

  const getProductData = async () => {
    const res = await getTransactionListByCategory({
      keyword: '',
      platform: Platform.OS,
      page_size: 1000,
      page_index: 1,
      type: 'PRICE_TABLE',
      category_id: -1,
    });
    if (res.status == 200 && res.data.code == 200) {
      setDataProduct(res.data.data);
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), I18n.t('Can_not_get_data'));
    }
  };

  const onCalculator = async () => {
    const titles = [
      I18n.t('Product'),
      I18n.t('LotTransactionNumber'),
      I18n.t('OpenPrice'),
      I18n.t('CloseStatusPrice'),
    ];
    const index = checkFormatArray([
      product,
      lotTransactionNumber,
      openPrice,
      closeStatusPrice,
    ]);

    if (index === true) {
      props.showLoading();

      const res = await getProfitLost({
        commodity_id: product.id,
        platform: Platform.OS,
        transaction_type: transactionType,
        lot_number: lotTransactionNumber,
        open_price: openPrice,
        close_price: closeStatusPrice,
      });
      props.hideLoading();
      if (res.status == 200 && res.data.code == 200) {
        const newList = [res.data.data].concat([...dataCalculator]);
        setDataCalculator(newList);
        setLotTransactionNumber(null);
        setOpenPrice(null);
        setCloseStatusPrice(null);
      } else {
        showAlert(
          TYPE.ERROR,
          I18n.t('Notification', I18n.t('Can_not_get_data')),
        );
      }

      // let newData = [...dataCalculator]
      // newData.push({
      //     name: product.name,
      //     status: RadioBuySale[transactionType].label,
      //     slot_number: 6,
      //     profit_loss_usd: 639324325,
      //     profit_loss_vnd: 1234349235455,
      // })
      // setDataCalculator(newData)
      // setLotTransactionNumber(null)
      // setOpenPrice(null)
      // setCloseStatusPrice(null)
    } else {
      showAlert(
        TYPE.ERROR,
        I18n.t('Notification'),
        `${I18n.t('Please_fill_in')}${titles[index]}`,
      );
    }
  };

  const onDelete = () => {
    setDataCalculator([]);
    setLotTransactionNumber(null);
    setOpenPrice(null);
    setCloseStatusPrice(null);
  };

  const setLotNumber = (text) => {
    setLotTransactionNumber(text.split(',').join(''));
  };

  const setOpenPriceEvent = (text) => {
    setOpenPrice(text.split(',').join(''));
  };
  const setCloseStatusEvent = (text) => {
    setCloseStatusPrice(text.split(',').join(''));
  };

  return (
    <CalculatorProfitLossView
      dataProduct={dataProduct}
      setProduct={setProduct}
      product={product}
      dataCalculator={dataCalculator}
      onCalculator={onCalculator}
      onDelete={onDelete}
      setTransactionType={setTransactionType}
      setLotNumber={setLotNumber}
      lotTransactionNumber={lotTransactionNumber}
      openPrice={openPrice}
      setOpenPrice={setOpenPriceEvent}
      closeStatusPrice={closeStatusPrice}
      setCloseStatusPrice={setCloseStatusEvent}
    />
  );
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {showLoading, hideLoading})(
  CalculatorProfitLoss,
);
