import React, {useState, useEffect} from 'react';
import {
  View,
  Text,
  StyleSheet,
  Platform,
  Linking,
  TouchableOpacity,
} from 'react-native';
import R from '../../assets/R';
import AppText from '../../components/AppText';
import TextMulti from '../../components/Input/TextMulti';
import I18n from '../../helper/i18/i18n';
import {connect} from 'react-redux';
import HeaderBack from '../../components/Header/HeaderBack';
import {getFontXD, HEIGHTXD, WIDTHXD, callNumber} from '../../Config/Functions';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import {showAlert, TYPE} from '../../components/DropdownAlert';
import {sendRequest} from '../../apis/Functions/General';
import {useNavigation} from '@react-navigation/native';

const ServiceCustomerView = (props) => {
  const naviation = useNavigation();
  const [content, setContent] = useState('');

  const onClickSend = async () => {
    props.showLoading();
    const res = await sendRequest({content, platform: Platform.OS});
    props.hideLoading();
    if (res.data.code == 200) {
      naviation.goBack();
      showAlert(TYPE.SUCCESS, I18n.t('Notification'), res.data.message);
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
    }
  };
  console.log(props.user.company_info);

  const {
    name,
    email,
    website,
    hotline,
    office_day,
    office_hours,
    office_sat_time,
    office_sun_time,
    address,
    hotline_call,
  } = props.user.company_info;

  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'CustomerCare'} />
      <View
        style={{
          flex: 1,
          paddingHorizontal: 10,
          paddingTop: 10,
        }}>
        <AppText i18nKey={'HaNoiOffice'} style={styles.title} />
        <Text style={styles.txtContent}>{name}</Text>

        <AppText i18nKey={'Address'} style={styles.title} />
        <Text style={styles.txtContent}>{address}</Text>

        <View style={styles.row}>
          <Text style={styles.title}>Email:</Text>
          <Text style={styles.txtContent}> {email}</Text>
        </View>
        <TouchableOpacity
          onPress={async () => {
            const supported = await Linking.canOpenURL(website);
            if (supported) Linking.openURL(website);
          }}>
          <View style={styles.row}>
            <Text style={styles.title}>Website: </Text>
            <Text style={styles.txtLink}>{website}</Text>
          </View>
        </TouchableOpacity>

        <AppText i18nKey={'HotLine'} style={styles.title} />
        <TouchableOpacity onPress={() => callNumber(hotline_call)}>
          <Text style={styles.txtContent}>{hotline}</Text>
        </TouchableOpacity>

        <AppText i18nKey={'WorkingTime'} style={styles.title} />
        <View style={{flexDirection: 'row'}}>
          <View style={styles.wrapLeft}>
            <Text style={styles.txtContent}>{office_day}</Text>
          </View>

          <Text style={styles.txtRight}>{office_hours}</Text>
        </View>
        <View style={{flexDirection: 'row'}}>
          <View style={styles.wrapLeft}>
            <AppText i18nKey={'Saturday'} style={styles.txtContent} />
          </View>

          <Text style={styles.txtRight}>{office_sat_time}</Text>
        </View>
        <View style={{flexDirection: 'row'}}>
          <View style={styles.wrapLeft}>
            <AppText i18nKey={'Sunday'} style={styles.txtContent} />
          </View>

          <Text style={styles.txtRight}>{office_sun_time}</Text>
        </View>

        <View style={{marginTop: 20, flex: 1}}>
          <TextMulti
            onChangeText={(val) => setContent(val)}
            title={I18n.t('ContentRequire')}
          />
        </View>
        <View
          style={{
            justifyContent: 'center',
            alignItems: 'center',
            marginBottom: 20,
          }}>
          <TouchableOpacity onPress={onClickSend} style={styles.btn}>
            <AppText style={styles.txtBtn} i18nKey={'Send'} />
          </TouchableOpacity>
        </View>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  title: {
    fontSize: getFontXD(42),
    color: R.colors.main,
    marginTop: 5,
  },
  txtContent: {
    fontSize: getFontXD(42),
    marginTop: 5,
  },
  txtLink: {
    fontSize: getFontXD(42),
    marginTop: 5,
    textDecorationLine: 'underline',
    color: R.colors.main,
  },
  row: {
    flexDirection: 'row',
  },
  btn: {
    width: WIDTHXD(500),
    height: HEIGHTXD(120),
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.main,
    borderRadius: 5,
  },
  txtBtn: {
    fontSize: getFontXD(46),
    color: R.colors.white,
    fontWeight: 'bold',
  },
  txtRight: {
    marginLeft: 20,
    fontSize: getFontXD(42),
    marginTop: 5,
  },
  wrapLeft: {
    width: WIDTHXD(400),
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {showLoading, hideLoading})(
  ServiceCustomerView,
);
