import React, {Component} from 'react';

import {View, Text, StyleSheet, Image, TouchableOpacity} from 'react-native';
import Block from '../../../components/Block';
import Icon from 'react-native-vector-icons/AntDesign';
import {getFontXD, HEIGHTXD} from '../../../Config/Functions';
import R from '../../../assets/R';
import {useNavigation} from '@react-navigation/native';
import {DETAILNEW} from '../../../routers/ScreenNames';

const Item = (props) => {
  const navigate = useNavigation();
  const {title, image, published_at, id} = props.item;
  return (
    <TouchableOpacity
      onPress={() => navigate.navigate(DETAILNEW, {id})}
      style={styles.container}>
      <Text numberOfLines={2} style={styles.txtTitle}>
        {title}
      </Text>
      <View style={styles.row}>
        <Icon name={'calendar'} style={{marginRight: 10}} size={15} />
        <Text style={styles.txtDate}>{published_at}</Text>
      </View>

      <Image source={{uri: image}} resizeMode={'cover'} style={styles.img} />
    </TouchableOpacity>
  );
};

const styles = StyleSheet.create({
  container: {
    marginTop: 15,
  },
  row: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    marginVertical: 10,
  },

  txtTitle: {
    fontSize: getFontXD(42),
    color: 'black',
    fontWeight: 'bold',
  },
  txtDate: {
    fontSize: getFontXD(36),
    color: '#A2A2A2',
  },
  img: {
    height: HEIGHTXD(500),
    borderRadius: 10,
    marginTop: 5,
  },
  row: {
    flexDirection: 'row',
    alignItems: 'center',
  },
});

export default Item;
