import React, {Component} from 'react';
import {View, Text, StyleSheet} from 'react-native';
import R from '../../../assets/R';
import Block from '../../../components/Block';
import {getFontXD, convertDate} from '../../../Config/Functions';
const Item = (props) => {
  const {title, date, time, start_date} = props.item;

  const d = new Date();
  return (
    <View
      style={[
        styles.container,
        d.getDate() == convertDate(start_date).slice(0, 2)
          ? {backgroundColor: '#B4D5FF'}
          : {},
      ]}>
      <View style={styles.left}>
        <View
          style={[
            styles.dot,
            d.getDate() == convertDate(start_date).slice(0, 2)
              ? {backgroundColor: 'red'}
              : {},
          ]}
        />
      </View>
      <View style={[styles.right, props.index == 0 ? {borderTopWidth: 0} : {}]}>
        <View style={styles.row}>
          <Text
            style={[
              styles.txtTime,
              d.getDate() == convertDate(start_date).slice(0, 2)
                ? {color: 'red', fontWeight: '500'}
                : {},
            ]}>
            {' '}
            {convertDate(start_date)}
          </Text>
          <Text
            style={[
              styles.txtDate,
              d.getDate() == convertDate(start_date).slice(0, 2)
                ? {color: 'red', fontWeight: '500'}
                : {},
            ]}>
            {start_date.substring(10, 16)}
          </Text>
        </View>
        <Text style={styles.txtTitle}>{title}</Text>
      </View>
    </View>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    flexDirection: 'row',
    paddingLeft: 20,
    paddingRight: 20,
  },
  left: {
    width: 1,
    backgroundColor: '#A7A7A7',
  },
  right: {
    marginLeft: 20,
    paddingVertical: 10,
    borderTopWidth: 0.6,
    borderBottomWidth: 0.6,
    borderColor: '#CECECE',
    flex: 1,
  },
  row: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginBottom: 5,
  },
  dot: {
    width: 10,
    height: 10,
    backgroundColor: R.colors.main,
    borderRadius: 5,
    marginLeft: -5,
    marginTop: 15,
  },
  txtTitle: {
    fontSize: getFontXD(42),
  },
  txtTime: {
    fontSize: getFontXD(42),
    color: R.colors.main,
  },
  txtDate: {
    color: '#A7A7A7',
  },
});
