import React, {useState, useEffect} from 'react';
import {View, FlatList, Text, Alert} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import Item from './Item';
import AppText from '../../../components/AppText';
import {getListTransaction} from '../../../apis/Functions/Widthdraw';
import I18n from '../../../helper/i18/i18n';
import {showAlert, TYPE} from '../../../components/DropdownAlert';

const Payments = (props) => {
  const [page, setPage] = useState(1);
  const [data, setData] = useState([]);
  const [tottalPage, setTotalPage] = useState(1);
  const [isRefresh, setisRefresh] = useState(false);
  useEffect(() => {
    getData();
  }, []);
  const getData = async () => {
    setisRefresh(true);
    setPage(1);
    const res = await getListTransaction({
      keyword: '',
      type: 'PAYMENT',
      platform: Platform.OS,
      page_size: 10,
      status: -1,
      page_index: 1,
      start_date: '',
      end_date: '',
    });
    setisRefresh(false);
    if ((res.data.code = 200 && res.data.data)) {
      setData(res.data.data);
      setTotalPage(res.data.meta.pages);
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
    }
  };

  const onRefresh = () => {
    getData();
  };

  const onLoadMore = () => {
    if (page < tottalPage) getDataLoadMore();
  };

  const getDataLoadMore = async () => {
    setisRefresh(true);
    const res = await getListTransaction({
      keyword: '',
      type: 'PAYMENT',
      platform: Platform.OS,
      page_size: 10,
      status: -1,
      page_index: page + 1,
      start_date: '',
      end_date: '',
    });
    setPage(page + 1);

    if (res.data.code == 200) {
      setData(data.concat(res.data.data));
    }
    setisRefresh(false);
  };

  return (
    <View style={{flex: 1}}>
      <HeaderBack isWhite={false} title={'Payments'} />

      <FlatList
        keyExtractor={(item) => item.id}
        data={data}
        refreshing={isRefresh}
        showsVerticalScrollIndicator={false}
        onRefresh={onRefresh}
        onEndReachedThreshold={0.01}
        onEndReached={(info) => {
          onLoadMore();
        }}
        keyExtractor={(item) => item.transection_id + 'a'}
        renderItem={({item}) => <Item item={item} />}
      />
    </View>
  );
};

export default Payments;
