import React, {useState, useEffect} from 'react';
import {
    View,
    Text,
    FlatList,
    StyleSheet,
    TouchableOpacity,
    ScrollView, Image,
} from 'react-native';

import {getFontXD, HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import R from '../../assets/R';
import ItemPrice from './ItemPrice';
import {PRODUCTDETAIL} from '../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';

const PriceListView = (props) => {
    const {setFilterId, filters, dataPrice, filterId, onSortByName, onSortByPercent, onSortByPriceOpenClose, onSortByPriceHighLow} = props;
    const navigate = useNavigation();
    return (
        <View style={{flex: 1}}>
            <View style={styles.headerContainer}>
                <ScrollView horizontal showsHorizontalScrollIndicator={false}>
                    {filters?.map((e) => (
                        <TouchableOpacity
                            key={e.id}
                            onPress={() => setFilterId(e.id)}
                            style={[
                                styles.itemFillter,
                                filterId == e.id ? {borderColor: '#1473E6'} : null,
                            ]}>
                            <Text
                                style={[
                                    styles.txtFillter,
                                    filterId == e.id ? {color: '#1473E6'} : {},
                                ]}>{e.name}</Text>
                        </TouchableOpacity>
                    ))}
                </ScrollView>
            </View>
            <FlatList
                style={{paddingBottom: HEIGHTXD(15), backgroundColor: R.colors.white}}
                keyExtractor={(item) => item.id}
                data={dataPrice}
                ListHeaderComponent={() =>
                    <View style={[styles.container]}>
                        <TouchableOpacity style={{flex: 0.3}} onPress={() => onSortByName()}>
                            <View style={[styles.headerContent, {
                                flex: 0.3,
                                justifyContent: 'flex-start',
                                alignItems: 'center',
                            }]}>
                                <Text>Tên</Text>
                                <Image source={R.images.iconSort} style={styles.imgIcon}/>
                            </View>
                        </TouchableOpacity>
                        <TouchableOpacity style={[styles.headerContent, {flex: 1.5}]} onPress={() => onSortByPercent()}>
                            <View style={[styles.headerContent]}>
                                <Text>Tỷ lệ thay đổi</Text>
                                <Image source={R.images.iconSort} style={styles.imgIcon}/>
                            </View>
                        </TouchableOpacity>
                        <TouchableOpacity style={styles.headerContent} onPress={() => onSortByPriceOpenClose()}>
                            <View style={[styles.headerContent]}>
                                <Text>Giá mở/đóng</Text>
                                <Image source={R.images.iconSort} style={styles.imgIcon}/>
                            </View>
                        </TouchableOpacity>
                        <TouchableOpacity style={{flex: 1}} onPress={() => onSortByPriceHighLow()}>
                            <View style={[styles.headerContent]}>
                                <Text>Giá cao/thấp</Text>
                                <Image source={R.images.iconSort} style={styles.imgIcon}/>
                            </View>
                        </TouchableOpacity>
                    </View>}
                renderItem={({item}) => <ItemPrice item={item}
                                                   onPress={() => navigate.navigate(PRODUCTDETAIL, {
                                                       id: item.id,
                                                       name: item.name,
                                                   })}/>}
            />
        </View>
    );
};

const styles = StyleSheet.create({
    headerContainer: {
        paddingVertical: 10,
        backgroundColor: 'white',
        flexDirection: 'row',
        alignItems: 'center',
        paddingHorizontal: 10,
    },
    itemFillter: {
        borderRadius: WIDTHXD(40),
        paddingVertical: HEIGHTXD(10),
        paddingHorizontal: WIDTHXD(25),
        borderWidth: 1,
        borderColor: '#929292',
        justifyContent: 'center',
        alignItems: 'center',
        marginRight: WIDTHXD(20),
    },
    txtFillter: {
        fontSize: getFontXD(36),
        color: '#929292',
        fontWeight: 'bold',
    },
    txtTitle: {
        fontSize: getFontXD(39),
        fontWeight: 'bold',
    },
    container: {
        flex: 1,
        flexDirection: 'row',
        marginHorizontal: WIDTHXD(30),
        marginBottom: HEIGHTXD(10),

    },
    headerContent: {
        flex: 1,
        flexDirection: 'row',
        justifyContent: 'flex-end',
        alignItems: 'center',
    },
    imgIcon: {
        width: WIDTHXD(20),
        height: WIDTHXD(35),
        resizeMode: 'contain',
    },
});

export default PriceListView;
