import React, {useState} from 'react';
import {
  View,
  StyleSheet,
  Text,
  KeyboardAvoidingView,
  Platform,
  TextInput,
  Image,
  TouchableOpacity,
  ImageBackground,
  ScrollView,
  TouchableWithoutFeedback,
  Keyboard,
} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
import PickerImg from '../../components/Picker/PickerImg';
import R from '../../assets/R';
import Button from '../../components/Button';
import I18n from '../../helper/i18/i18n';
import AppText from '../../components/AppText';
import {Rating, AirbnbRating} from 'react-native-ratings';

const FeedbackView = (props) => {
  const [txtInput, setTxtInput] = useState('');
  const [imageAdd, setImageAdd] = useState('');
  const [star_rate, setStarRate] = useState(5);

  const onPress = (value) => {
    setIsSelected(value);
    // console.log('hellooo');
  };

  const onClickImages = (image) => {
    console.log(image);
    setImageAdd(image);
  };

  const ratingCompleted = (rating) => {
    setStarRate(rating);
  };
  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1, backgroundColor: 'white'}}
      keyboardVerticalOffset={-50}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <View style={{flex: 1}}>
          <HeaderBack isWhite={true} title={'SendFeedback'} />
          <View style={styles.container}>
            <AppText style={styles.txt} i18nKey={'FeedBackDCV'} />
            <Rating
              startingValue={star_rate}
              onFinishRating={ratingCompleted}
              style={{paddingVertical: 10}}
            />
            <View style={styles.footer}>
              <TextInput
                style={styles.txtInput}
                placeholderTextColor={R.colors.placeHolder}
                multiline={true}
                onChangeText={(val) => setTxtInput(val)}
              />
              <View
                style={{
                  borderWidth: 1,
                  borderStyle: 'dashed',
                  borderColor: '#CBCBCB',
                }}
              />
              <View style={styles.picker}>
                <PickerImg
                  image={imageAdd}
                  title={''}
                  onClickImage={onClickImages}
                />
              </View>
            </View>
          </View>

          <View style={styles.containerBtn}>
            <Button
              onClick={() => props.onClickSend(star_rate, imageAdd, txtInput)}
              title={I18n.t('SendFeedback')}
            />
          </View>
        </View>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    paddingHorizontal: 30,
    paddingVertical: 10,
  },
  txt: {
    color: '#929292',
    paddingVertical: 16,
    fontSize: 18,
  },
  footer: {
    marginTop: 10,
    borderRadius: 6,
    borderWidth: 2,
    borderColor: '#CBCBCB',
    // height: 200,
    marginHorizontal: 5,
  },
  txtInput: {
    height: 110,
    margin: 10,
  },
  picker: {
    marginLeft: 10,
    marginBottom: 10,
  },
  imageButton: {
    marginTop: 10,
    marginRight: 20,
  },
  containerBtn: {
    marginBottom: 30,
    backgroundColor: 'white',
  },
});

export default FeedbackView;
