import React from 'react';
import {
  View,
  Text,
  KeyboardAvoidingView,
  Platform,
  SafeAreaView,
  StatusBar,
  TouchableWithoutFeedback,
  Keyboard,
  ImageBackground,
  Dimensions,
} from 'react-native';
import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
import {getFontXD, HEIGHTXD} from '../../Config/Functions';
import Login from './Login';
import Registor from './Registor';
import {ScrollView} from 'react-native-gesture-handler';
import R from '../../assets/R';
import I18n from '../../helper/i18/i18n';

const {width, height} = Dimensions.get('window');

const Tab = createMaterialTopTabNavigator();
const Authen = (props) => {
  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1, backgroundColor: 'white'}}
      keyboardVerticalOffset={-50}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <ScrollView showsVerticalScrollIndicator={false}>
          <StatusBar backgroundColor="transparent" translucent={true} />

          <ImageBackground
            resizeMode={'stretch'}
            style={{width: width, height}}
            source={R.images.bgLogin}>
            <Tab.Navigator
              initialRouteName="Login"
              tabBarOptions={{
                activeTintColor: '#0045C8',
                labelStyle: {fontSize: getFontXD(42), fontWeight: '700'},
                style: {
                  justifyContent: 'center',
                  marginHorizontal: 40,
                  elevation: 0,
                  marginTop: HEIGHTXD(700),
                },
              }}>
              <Tab.Screen
                name="LOGIN"
                component={Login}
                options={{tabBarLabel: I18n.t('Login')}}
              />
              <Tab.Screen
                name="REGISTOR"
                component={Registor}
                options={{tabBarLabel: I18n.t('Register')}}
              />
            </Tab.Navigator>
          </ImageBackground>
        </ScrollView>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

export default Authen;
