import React, {useEffect, useState} from 'react';
import {View, Text, StyleSheet, ScrollView} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import CheckBox from '@react-native-community/checkbox';
import R from '../../../assets/R';
import {getFontXD, toPriceVnd} from '../../../Config/Functions';

const ContainerTop = (props) => {
  const [isSelected, setSelection] = useState(false);
  const {title, data} = props.data;

  const [listItem, setListItem] = useState([]);

  useEffect(() => {
    const newList = data.map((e) => {
      return {...e, selected: false};
    });

    setListItem(newList);
  }, [props.data]);

  useEffect(() => {
    const newList = data.map((e) => {
      console.log(props.listRegister);
      if (props.listRegister.includes(e.id)) {
        console.log('Chay vao day', e.id);
        return {...e, selected: true};
      } else {
        console.log('Chay xuong duoi', e.id);
        return {...e, selected: false};
      }
    });

    setListItem(newList);
  }, [props.listRegister]);

  const onSelected = (selected) => {
    const newList = listItem.map((e) => {
      if (e.id != selected.id) return e;

      if (e.selected == false) props.onChoosePacket(e);
      else props.onRemovePacket(e);
      return {...e, selected: !e.selected};
    });
    setListItem(newList);
  };

  return (
    <View>
      <Text style={styles.txtTitle}> {title}</Text>
      <View style={styles.wrap}>
        {listItem.map((e) => (
          <View key={e.id + 'a'} style={styles.item}>
            <View style={{flex: 1}}>
              <Text>{e.name}</Text>
            </View>
            <View
              style={{
                width: 120,
                marginRight: 30,
                alignItems: 'flex-end',
              }}>
              <Text style={styles.txtMoney}>
                {toPriceVnd(e.price_package.price)}
              </Text>
            </View>
            <CheckBox
              value={e.selected}
              onValueChange={() => onSelected(e)}
              boxType={'square'}
            />
          </View>
        ))}
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    paddingHorizontal: 10,
    paddingTop: 10,
  },
  checkboxContainer: {
    flexDirection: 'row',
    marginBottom: 20,
  },

  checkbox: {
    alignSelf: 'flex-end',
  },
  txtNote: {
    fontStyle: 'italic',
  },
  wrap: {
    marginVertical: 10,
    backgroundColor: R.colors.white,
    paddingVertical: 10,
    borderRadius: 10,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  item: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    paddingHorizontal: 10,
    marginVertical: 10,
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: '#FFB721',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.main,
    marginTop: 10,
  },
  txtGroup: {
    fontSize: getFontXD(42),
    color: R.colors.main,

    fontStyle: 'italic',
  },
});

export default ContainerTop;
