<?php
/**
 * Template Name: Hompage
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since Twenty Sixteen 2.1
 */
get_header();

?>
<?php get_template_part( 'template-parts/content', 'intro-slider' ); ?>

<section id="show-hd">
	<div class="container container-fluid">
		<article class="row showhome">
			<div class="col-xs-12 col-sm-12 col-md-4 col-lg-4 wow jackInTheBox"><div class="img-showhome"></div></div>
			<div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
				<div class="content-showhome wow flipInX">
					<h3>HÓA ĐƠN ĐIỆN TỬ LÀ GÌ?</h3>
					<p>Hóa đơn điện tử là tập hợp các thông điệp dữ liệu điện tử về bán hàng hoá, cung ứng dịch vụ, được khởi tạo, lập, gửi, nhận, lưu trữ và quản lý bằng phương tiện điện tử. </p>
					<p>Hóa đơn điện tử phải đáp ứng các nội dung quy định tại Điều 6 Thông tư 32 này.</p>
					<p>Phương pháp tạo Hóa đơn điện tử: </p>
					<ul>
						<li> Được khởi tạo, lập, gửi, nhận, lưu trữ và quản lý bằng phương tiện điện tử. </li>
						<li>Có thể chuyển đổi thành hóa đơn giấy trong nhu cầu lưu thông hàng hóa, quản lý hóa đơn của người mua.</li>
					</ul>			
				</div>
			</div>
		</article>
	</div>
</section>

<?php get_template_part('template-parts/feature-component-tpl', 'none');?>

<section id='main-feature'>
	<div class="container">
		<h2 class="mf-title">Lợi ích nổi bật của "A HÓA ĐƠN"</h2>
		<p class="mf-title-sub">Lợi ích của hóa đơn điện tử đối với doanh nghiệp:</p>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
				<div class="content-ft-1 wow rotateInUpLeft">
					<h3>AN TOÀN</h3>
					<p>Không xảy ra cháy, hỏng, mất hóa đơn. Tăng độ tin cậy cho hóa đơn của doanh nghiệp</p>
					<div class="icon-ft-1"></div>
				</div>
			</div>
			<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
				<div class="content-ft-2 wow rotateInUpRight">
					<h3>NHANH CHÓNG</h3>
					<p>Người mua tức thời nhận được hóa đơn, rút ngắn thời gian thu nợ</p>
					<div class="icon-ft-2"></div>
				</div>
			</div>
			<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
				<div class="content-ft-3 wow rotateInUpLeft" >
					<h3>TIẾT KIỆM</h3>
					<p>Tiết kiệm 90% chi phí in ấn, vận chuyển, lưu trữ và bảo quản hóa đơn</p>
					<div class="icon-ft-3"></div>
				</div>
			</div>
			<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
				<div class="content-ft-4 wow rotateInUpRight" >
					<h3>BẢO VỆ MÔI TRƯỜNG</h3>
					<p>Giảm bớt việc sử dụng giấy, góp phần bảo vệ môi trường</p>
					<div class="icon-ft-4"></div>
				</div>
			</div>
			<div id="lienket">
				<div class="btn btn-1 wow zoomIn"><a href="<?=get_permalink(253)?>">Đăng ký sử dụng</a></div>
				<div class="btn btn-2 wow zoomIn"><a href="<?=get_permalink(2370)?>">Đăng ký đại lý</a></div>
			</div>
		</div>
	</div>
</section>

<section id="prices">
	<div class="container">
		<h2 class="prices-title">BẢNG GIÁ PHẦN MỀM "A HÓA ĐƠN"</h2>
		<div id="price_slider" class="row">
		<?php
			// Products per page
			$per_page = 10;
			if ( get_query_var( 'taxonomy' ) ) { // If on a product taxonomy archive (category or tag)
				$args = array(
					'post_type'      => 'product',
					'posts_per_page' => $per_page,
					'paged'          => get_query_var( 'paged' ),
					'orderby'        => 'meta_value_num',
					'order'          => 'ASC',
					'meta_key'       => '_price',
					'product_cat'    => 'goi-hoa-don',
					'tax_query'      => array(
						array(
							'taxonomy' => get_query_var( 'taxonomy' ),
							'field'    => 'slug',
							'terms'    => get_query_var( 'term' ),
						),
					),
				);
			} else { // On main shop page
				$args = array(
					'post_type'      => 'product',
					'orderby'        => 'meta_value_num',
					'order'          => 'ASC',
					'meta_key'       => '_price',
					'product_cat'    => 'goi-hoa-don',
					'posts_per_page' => $per_page,
					'paged'          => get_query_var( 'paged' ),
				);
			}
			// Set the query
			$products = new WP_Query( $args );
			$home_url = home_url( $wp->request );
			// Standard loop
			
			if ( $products->have_posts() ) :
				while ( $products->have_posts() ) : $products->the_post();
					// Your new HTML markup goes here
					global $product;
					global $wp;
					// echo '<br /><a href="'.get_permalink().'">' . woocommerce_get_product_thumbnail().' '.get_the_title().'</a>';
					?>
					<div class="col-xs-12 col-sm-12 col-md-4">
						<div class="card text-center box-price wow slideInUp">
							<h2 class="card-header"><?php the_title(); ?></h2>
							<article class="card-body">
								<p class="card-text">Số hóa đơn</p>
								<h5 class="card-title"><?php echo number_format($product->get_attribute( 'so-luong-hoa-don' ),0,",","."); ?></h5>
								<p class="card-text">Giá tiền</p>
								<p class="card-money"><?php echo $product->get_price_html()?></p>
								<a href="<?php echo wc_get_cart_url() . do_shortcode('[add_to_cart_url id="'.$product->ID.'"]');?>" class="btn btn-primary">Mua ngay</a>
								<?php //echo do_shortcode('[add_to_cart id="'.$product->ID.'" style="border-right:1px solid #ccc"]')?>
							</article>
						</div>
					</div>
					<?php
				endwhile;
				wp_reset_postdata();
			endif;
			?>
		</div>
		<div class="row text-center price_fee">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 wow zoomIn">
				<p class="txt-red">	PHÍ KHỞI TẠO: 500.000 VNĐ </p>
				<p>Phí chưa bao gồm VAT 10%</p>
			</div>
		</div>
	</div>
</section>

<?php 
	$recent_posts = wp_get_recent_posts(array(
	    'numberposts' => 3, // Number of recent posts thumbnails to display
	    'post_status' => 'publish' // Show only the published posts
	));
    
?>

<div id="tintucnoibat">
	<div class="container">
		<h2>Tin tức nổi bật</h2>
		<div class="row">
			<?php foreach($recent_posts as $post) : ?>
			 <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4 item ">
			 	<div class="item-child imghover boxhover" title="<?php echo $post['post_title'] ?>" >
				<?php $img_url = get_the_post_thumbnail_url($post['ID']); ?>
					<figure>
						<div class="img wow slideInUp">
							<a href="<?php echo get_permalink($post['ID']) ?>" >
							<div class="bg_img" style="height:200px;width:100%;background: url('<?php echo $img_url; ?>') no-repeat center center; background-size: cover;border-radius: 10px 10px 0px 0px;"></div>
							</a>
						</div>
					</figure>
				 	<div class="title"><a href="<?php echo get_permalink($post['ID']) ?>"><?php echo $post['post_title'] ?></a></div>
				 	<div class="desc_ct item-text"><p><?php echo $post['post_excerpt']; ?></p></div>
				 	<div class="lienket"><a href="<?php echo get_permalink($post['ID']) ?>">Xem thêm</a></div>
			 	</div>
			 </div>
			 <?php endforeach; wp_reset_query(); ?>
		</div>	
	</div>
</div>
<div id="danhgia">
	<div class="container">
		<h2>Khách hàng và đối tác</h2>
		<p class="desp">Nói về chúng tôi</p>
		<div class="wow zoomInUp">
			<?php echo do_shortcode('[testimonials_slider design_template="template-4" grid="3" show_company="true"  image_style="circle" show_quotes="false" video="false" social="false" dots="true" arrows="false"]'); ?>
		</div>
	</div>
</div>
<?php get_footer(); ?>