<?php get_header(); ?>
<?php get_template_part( 'template-parts/content', 'intro-slider' ); ?>
<section id="prices">
	<div class="container">
		<h2 class="prices-title">BẢNG GIÁ PHẦN MỀM A HÓA ĐƠN</h2>
        <div class="row">
            <!-- <main class="col-xs-12 col-sm-12 col-md-12 col-lg-12"> -->

                <?php
                    // Only run on shop archive pages, not single products or other pages
                    if ( is_shop() || is_product_category() || is_product_tag() ) {
                        // Products per page
                        $per_page = 12;
                        if ( get_query_var( 'taxonomy' ) ) { // If on a product taxonomy archive (category or tag)
                            $args = array(
                                'post_type'      => 'product',
                                'posts_per_page' => $per_page,
                                'paged'          => get_query_var( 'paged' ),
                                'orderby'        => 'meta_value_num',
                                'order'          => 'ASC',
                                'meta_key'       => '_price',
                                'tax_query'      => array(
                                    array(
                                        'taxonomy' => get_query_var( 'taxonomy' ),
                                        'field'    => 'slug',
                                        'terms'    => get_query_var( 'term' ),
                                    ),
                                ),
                            );
                        } else { // On main shop page
                            $args = array(
                                'post_type'      => 'product',
                                'orderby'        => 'meta_value_num',
                                'order'          => 'ASC',
                                'meta_key'       => '_price',
                                'posts_per_page' => $per_page,
                                'paged'          => get_query_var( 'paged' ),
                            );
                        }
                        // Set the query
                        $products = new WP_Query( $args );
                        $home_url = home_url( $wp->request );
                        // Standard loop
                        
                        if ( $products->have_posts() ) :
                            while ( $products->have_posts() ) : $products->the_post();
                                // Your new HTML markup goes here
                                global $product;
                                global $wp;
                                // print_r($product);
                                // echo '<br /><a href="'.get_permalink().'">' . woocommerce_get_product_thumbnail().' '.get_the_title().'</a>';
                                ?>
                                <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                    <div class="card text-center box-price wow flipInY">
                                        <h2 class="card-header"><?php the_title(); ?></h2>
                                        <article class="card-body">
                                            <p class="card-text">Số hóa đơn</p>
                                            <h5 class="card-title"><?php echo number_format($product->get_attribute( 'so-luong-hoa-don' ),0,",","."); ?></h5>
                                            <p class="card-text">Giá tiền</p>
                                            <p class="card-money"><?php echo number_format($product->price,0,',','.')?></p>
                                            <a href="<?php echo get_permalink() . do_shortcode('[add_to_cart_url id="'.$product->ID.'"]')?>" class="btn btn-primary">Mua ngay</a>
                                            <?php //echo do_shortcode('[add_to_cart id="'.$product->ID.'" style="border-right:1px solid #ccc"]')?>
                                        </article>
                                    </div>
                                </div>
                                <?php
                            endwhile;
                            wp_reset_postdata();
                        endif;
                    } else { // If not on archive page (cart, checkout, etc), do normal operations
                        woocommerce_content();
                    }
                ?>

            <!-- </main> -->
        </div>
    </div>
</section>
<?php get_footer(); ?>