<?php
/**
 * The template for the sidebar containing the main widget area
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since Twenty Sixteen 1.0
 */

$recent_posts = wp_get_recent_posts(array(
    'numberposts' => 4, // Number of recent posts thumbnails to display
    'post_status' => 'publish' // Show only the published posts
));
    
?>

<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
	<!-- <aside id="secondary" class="sidebar widget-area" role="complementary"> -->
		<?php //dynamic_sidebar( 'sidebar-1' ); ?>
	<!-- </aside>.sidebar .widget-area -->

	<aside class="sidebar most-views">
		<div class="title-sidebar">
			<h2>TIN TỨC NỔI BẬT</h2>
		</div>
		<div class="content-sidebar">
			<ul>
				<?php foreach($recent_posts as $post) : ?>
			        <li class="item-sidebar">
			            <a href="<?php echo get_permalink($post['ID']) ?>">
			                <img src="<?php echo get_the_post_thumbnail_url($post['ID']); ?>" class="img-fluid">
			                <p class="title-item-sidebar"><?php echo $post['post_title'] ?></p>
			            </a>
			        </li>
			    <?php endforeach; wp_reset_query(); ?>
			</ul>
		</div>
	</aside>
<?php endif; ?>
