<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since Twenty Sixteen 1.0
 */

get_header(); 
    $cat_id = 4;
    $cat = get_category($cat_id);
?>
<!-- Khu vực content -->
<?php get_template_part( 'template-parts/content', 'intro-slider' ); ?>

<div class="container category">
	<div class="content-title">
        <h3><?=$cat->name?></h3>
    </div>
	<div class="row">
		<div class="col-md-12 col-lg-12">
		    <div id="category-content">
		        <div class="news">
		        	<div class="content-box">
		            	<div class="content-item">
		                    <div class="row">
		                        <?php if (have_posts()) : ?>
		                            <?php
		                                    // Start the Loop.
		                            while (have_posts())
		                                : the_post();
		                                
		                                        /*
		                            * Include the Post-Format-specific template for the content.
		                            * If you want to override this in a child theme, then include a file
		                            * called content-___.php (where ___ is the Post Format name) and that will be used instead.
		                            */
		                            get_template_part('template-parts/content', get_post_format());

		                                        // End the loop.
		                            endwhile;

		                                    // Previous/next page navigation.
		                            

		                                    // If no content, include the "No posts found" template.
		                            else :
		                                get_template_part('template-parts/content', 'none');
		                            endif;
		                        ?>
		                    </div>
		                </div>
		            </div>
		        </div>
		        <div class="pagination-news">
		            <?php 
		            // ea_archive_navigation();
		            the_posts_pagination( array(
						'prev_text' => __( '<i class="fas fa-chevron-left"></i>', 'Hoadonviet' ),
						'next_text' => __( '<i class="fas fa-chevron-right"></i>', 'Hoadonviet' ),
					) );
		            //the_posts_pagination(
		            //     array(
		            //         'prev_text' => __('<', 'Hoadonviet'),
		            //         'next_text' => __('>', 'Hoadonviet'),
		            //         'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('Page', 'Hoadonviet') . ' </span>',
		            //     )
		            // );
		            ?>
		        </div>
		    </div>
	    </div>
	    <!-- <div class="col-md-3"> -->
	    	<?php //get_sidebar(); ?>
	    <!-- </div> -->
	</div>
</div>
<?php get_footer(); ?>
