<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since Twenty Sixteen 1.0
 */

get_header(); 
    $cat_id = 4;
    $cat = get_category($cat_id);
?>
<!-- Khu vực content -->
<section id="intro-hd">
	<div class="container container-fluid">
		<article class="row introduce">
			<div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
				<h2>A HÓA ĐƠN</h2>
				<p class="sub-tit">Giải pháp hóa đơn điện tử chuyên nghiệp</p>
				<p><span class="txt-red">A hóa đơn</span> giúp dễ dàng tạo lập, phát hành, quản lý hóa đơn với nhiều tính năng cao cấp, phù hợp đa dạng loại hình, quy mô doanh nghiệp</p>
				<div id="lienket">
					<div class="btn btn-1"><a href="#">Đăng ký sử dụng</a></div>
					<div class="btn btn-2"><a href="#">Đăng ký đại lý</a></div>
				</div>
			</div>
			<div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
				<?php echo do_shortcode("[URIS id=18]"); ?>
			</div>
		</article>
	</div>
</section>
<div class="container category">
	<div class="content-title">
        <h3><?=$cat->name?></h3>
    </div>
	<div class="row">
		<div class="col-md-12 col-lg-12">
		    <div id="category-content">
		        <div class="news">
		        	<div class="content-box">
		            	<div class="content-item">
		                    <div class="row">
		                        <?php if (have_posts()) : ?>
		                            <?php
		                                    // Start the Loop.
		                            while (have_posts())
		                                : the_post();
		                                
		                                        /*
		                            * Include the Post-Format-specific template for the content.
		                            * If you want to override this in a child theme, then include a file
		                            * called content-___.php (where ___ is the Post Format name) and that will be used instead.
		                            */
		                            get_template_part('template-parts/content', get_post_format());

		                                        // End the loop.
		                            endwhile;

		                                    // Previous/next page navigation.
		                            

		                                    // If no content, include the "No posts found" template.
		                            else :
		                                get_template_part('template-parts/content', 'none');
		                            endif;
		                        ?>
		                    </div>
		                </div>
		            </div>
		        </div>
		        <div class="pagination-news">
		            <?php 
		            // ea_archive_navigation();
		            the_posts_pagination( array(
						'prev_text' => __( '<i class="fas fa-chevron-left"></i>', 'Hoadonviet' ),
						'next_text' => __( '<i class="fas fa-chevron-right"></i>', 'Hoadonviet' ),
					) );
		            //the_posts_pagination(
		            //     array(
		            //         'prev_text' => __('<', 'Hoadonviet'),
		            //         'next_text' => __('>', 'Hoadonviet'),
		            //         'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('Page', 'Hoadonviet') . ' </span>',
		            //     )
		            // );
		            ?>
		        </div>
		    </div>
	    </div>
	    <!-- <div class="col-md-3"> -->
	    	<?php //get_sidebar(); ?>
	    <!-- </div> -->
	</div>
</div>
<?php get_footer(); ?>
